/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.common.exception.NotImplementedException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.SpeciesMapping;
import lcsb.mapviewer.converter.model.celldesigner.structure.SpeciesState;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.InconsistentModelException;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.AntisenseRnaRegion;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import lcsb.mapviewer.model.map.species.fields.ModificationState;
import lcsb.mapviewer.model.map.species.fields.PositionToCompartment;
import lcsb.mapviewer.model.map.species.fields.RnaRegion;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeciesSbmlParser
extends AbstractElementXmlParser<Species> {
    private Logger logger = Logger.getLogger(SpeciesSbmlParser.class.getName());
    private Model model = null;

    public SpeciesSbmlParser(Model model) {
        this.model = model;
    }

    @Override
    public Pair<String, Species> parseXmlElement(Node spieciesNode, List<String> warnings) throws InvalidXmlSchemaException {
        NodeList list = spieciesNode.getChildNodes();
        Node annotationNode = null;
        Node notesNode = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("annotation")) {
                annotationNode = node;
                continue;
            }
            if (node.getNodeName().equals("notes")) {
                notesNode = node;
                continue;
            }
            this.logger.warn("Unknown element of annotation " + node.getNodeName());
        }
        if (annotationNode == null) {
            throw new InvalidXmlSchemaException("No annotation node in SBML/model/listOfSpecies/species");
        }
        list = annotationNode.getChildNodes();
        Node extensionNode = null;
        Node rdfNode = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:extension")) {
                extensionNode = node;
                continue;
            }
            if (node.getNodeName().equals("rdf:RDF")) {
                rdfNode = node;
                continue;
            }
            this.logger.warn("Unknown element of annotation " + node.getNodeName());
        }
        if (extensionNode == null) {
            throw new InvalidXmlSchemaException("No celldesigner:extension node in SBML/model/listOfSpecies/species/annotation");
        }
        list = extensionNode.getChildNodes();
        Node speciesIdentity = null;
        Node positionToCompartment = null;
        boolean log = false;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:speciesIdentity")) {
                speciesIdentity = node;
                continue;
            }
            if (node.getNodeName().equals("celldesigner:positionToCompartment")) {
                positionToCompartment = node;
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfCatalyzedReactions")) continue;
            log = true;
            this.logger.warn("Unknown element of celldesigner:extension " + node.getNodeName());
        }
        if (speciesIdentity == null) {
            throw new InvalidXmlSchemaException("No celldesigner:extension node in SBML/model/listOfSpecies/species/annotation/speciesIdentity");
        }
        Pair<String, Species> result = this.parseSpeciesIdentity(speciesIdentity);
        Species species = result.getRight();
        if (positionToCompartment != null) {
            PositionToCompartment position = PositionToCompartment.getByString(this.getNodeValue(positionToCompartment));
            if (position == null) {
                throw new InvalidArgumentException("Unknown position on compartment: " + this.getNodeValue(positionToCompartment));
            }
            species.setPositionToCompartment(position);
        }
        species.setMetaId(this.getNodeAttr("metaid", spieciesNode));
        species.setIdSpecies(this.getNodeAttr("id", spieciesNode));
        species.setName(this.decodeName(this.getNodeAttr("name", spieciesNode)));
        species.setInitialAmount(this.getNodeAttr("initialAmount", spieciesNode));
        species.setInitialConcentration(this.getNodeAttr("initialConcentration", spieciesNode));
        species.setCharge(this.getNodeAttr("charge", spieciesNode));
        species.setOnlySubstanceUnits(this.getNodeAttr("hasOnlySubstanceUnits", spieciesNode));
        Compartment compartment = this.model.getCompartmentByCompartmentId(this.getNodeAttr("compartment", spieciesNode));
        if (compartment != null) {
            species.setParent(compartment);
        }
        if (notesNode != null) {
            this.getRap().processNotes(notesNode, (Element)species, warnings);
        }
        if (rdfNode != null) {
            XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser();
            species.addMiriamData(xmlAnnotationParser.parseRdfNode(annotationNode.getChildNodes(), warnings), warnings);
        }
        if (log) {
            this.logger.debug(species.getIdSpecies() + ", " + species.getName());
        }
        return result;
    }

    @Override
    public String toXml(Species species) throws InconsistentModelException {
        StringBuilder builder = new StringBuilder();
        StringBuilder attributesBuilder = new StringBuilder();
        attributesBuilder.append(" name=\"" + this.escapeXml(species.getName()) + "\"");
        attributesBuilder.append(" id=\"" + species.getIdSpecies() + "\"");
        attributesBuilder.append(" metaid=\"" + species.getMetaId() + "\"");
        if (species.getInitialAmount() != null) {
            attributesBuilder.append(" initialAmount=\"" + species.getInitialAmount() + "\"");
        }
        if (species.getInitialConcentration() != null) {
            attributesBuilder.append(" initialConcentration=\"" + species.getInitialConcentration() + "\"");
        }
        if (species.getCharge() != null) {
            attributesBuilder.append(" charge=\"" + species.getCharge() + "\"");
        }
        if (species.hasOnlySubstanceUnits() != null) {
            attributesBuilder.append(" hasOnlySubstanceUnits=\"" + species.hasOnlySubstanceUnits() + "\"");
        }
        if (species.getParent() != null && species.getParent() instanceof Compartment) {
            Compartment comp = species.getParent();
            attributesBuilder.append(" compartment=\"" + comp.getCompartmentId() + "\"");
        } else {
            Model m = species.getModelData().getModel();
            if (m.getCompartmentByCompartmentId("default") == null) {
                throw new InconsistentModelException("Default compartment doesn't exist, but element without compartment found");
            }
            attributesBuilder.append(" compartment=\"default\"");
        }
        builder.append("<species " + attributesBuilder.toString() + ">");
        if (species.getNotes() != null && !species.getNotes().equals("") || species.getSymbol() != null || species.getFullName() != null || species.getSynonyms().size() > 0) {
            builder.append("<notes>");
            builder.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>");
            RestAnnotationParser rap = new RestAnnotationParser();
            builder.append(rap.createAnnotationString(species));
            if (species.getNotes() != null) {
                builder.append(species.getNotes());
            }
            builder.append("</body></html>");
            builder.append("</notes>\n");
        }
        builder.append("<annotation>");
        builder.append("<celldesigner:extension>");
        if (species.getPositionToCompartment() != null) {
            builder.append("<celldesigner:positionToCompartment>" + (Object)((Object)species.getPositionToCompartment()) + "</celldesigner:positionToCompartment>");
        }
        builder.append(this.speciesIdentityToXml(species));
        builder.append("</celldesigner:extension>\n");
        XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser();
        builder.append(xmlAnnotationParser.dataSetToXmlString((Set<MiriamData>)species.getMiriamData()));
        builder.append("</annotation>\n");
        builder.append("</species>\n");
        return builder.toString();
    }

    String speciesIdentityToXml(Species species) {
        StringBuilder sb = new StringBuilder();
        String classType = "";
        SpeciesMapping mapping = SpeciesMapping.getMappingByClass(species.getClass());
        if (mapping == null) {
            throw new InvalidArgumentException("Invalid species class type: " + species.getClass().getName());
        }
        classType = mapping.getCellDesignerString();
        sb.append("<celldesigner:speciesIdentity>");
        sb.append("<celldesigner:class>" + classType + "</celldesigner:class>\n");
        if (species instanceof Rna) {
            sb.append("<celldesigner:rnaReference>r_" + species.getIdSpecies() + "</celldesigner:rnaReference>\n");
        } else if (species instanceof Protein) {
            sb.append("<celldesigner:proteinReference>p_" + species.getIdSpecies() + "</celldesigner:proteinReference>\n");
        } else if (species instanceof Gene) {
            sb.append("<celldesigner:geneReference>g_" + species.getIdSpecies() + "</celldesigner:geneReference>\n");
        } else if (species instanceof AntisenseRna) {
            sb.append("<celldesigner:antisensernaReference>ar_" + species.getIdSpecies() + "</celldesigner:antisensernaReference>\n");
        }
        SpeciesState state = new SpeciesState(species);
        sb.append(this.speciesStateToXml(state));
        sb.append("<celldesigner:name>" + this.escapeXml(species.getName()) + "</celldesigner:name>\n");
        Boolean hypothetical = species.getHypothetical();
        if (hypothetical != null) {
            sb.append("<celldesigner:hypothetical>" + hypothetical + "</celldesigner:hypothetical>\n");
        }
        sb.append("</celldesigner:speciesIdentity>\n");
        return sb.toString();
    }

    private String speciesStateToXml(SpeciesState state) {
        StringBuilder sb = new StringBuilder();
        if (state.getHomodimer() != 1) {
            sb.append("<celldesigner:homodimer>" + state.getHomodimer() + "</celldesigner:homodimer>\n");
        }
        if (state.getStructuralState() != null && !state.getStructuralState().equals("")) {
            sb.append("<celldesigner:listOfStructuralStates>\n");
            sb.append("<celldesigner:structuralState structuralState=\"" + state.getStructuralState() + "\">" + state.getStructuralState() + "</celldesigner:structuralState>");
            sb.append("</celldesigner:listOfStructuralStates>\n");
        }
        if (state.getModifications().size() > 0) {
            sb.append("<celldesigner:listOfModifications>\n");
            for (ModificationResidue mr : state.getModifications()) {
                sb.append(this.modificationResidueToXml(mr));
            }
            sb.append("</celldesigner:listOfModifications>\n");
        }
        if (sb.length() > 0) {
            sb.insert(0, "<celldesigner:state>\n");
            sb.append("</celldesigner:state>\n");
        }
        return sb.toString();
    }

    public Pair<String, Species> parseSpeciesIdentity(Node rootNode) throws InvalidXmlSchemaException {
        NodeList nodes = rootNode.getChildNodes();
        Species result = new Species();
        Node classNode = this.getNode("celldesigner:class", nodes);
        if (classNode == null) {
            StringWriter sw = new StringWriter();
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.setOutputProperty("indent", "yes");
                t.transform(new DOMSource(rootNode), new StreamResult(sw));
            }
            catch (TransformerException te) {
                this.logger.error("nodeToString Transformer Exception");
            }
            throw new InvalidXmlSchemaException("Species node in Sbml model doesn't contain class field. Node: " + sw.toString());
        }
        String value = this.getNodeValue(classNode);
        SpeciesMapping mapping = SpeciesMapping.getMappingByString(value);
        if (mapping == null) {
            throw new InvalidXmlSchemaException("Species node in Sbml model is of unknown type: " + value);
        }
        result = mapping.createSpecies(result);
        String identifier = "";
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("celldesigner:class")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:proteinReference")) {
                if (result instanceof Protein) {
                    identifier = this.getNodeValue(node);
                    continue;
                }
                throw new InvalidXmlSchemaException("Wrong class type for protein reference: " + result.getClass().getName());
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:geneReference")) {
                if (result instanceof Gene) {
                    identifier = this.getNodeValue(node);
                    continue;
                }
                throw new InvalidXmlSchemaException("Wrong class type for gene reference: " + result.getClass().getName());
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:rnaReference")) {
                if (result instanceof Rna) {
                    identifier = this.getNodeValue(node);
                    continue;
                }
                throw new InvalidXmlSchemaException("Wrong class type for rna reference: " + result.getClass().getName());
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:antisensernaReference")) {
                if (result instanceof AntisenseRna) {
                    identifier = this.getNodeValue(node);
                    continue;
                }
                throw new InvalidXmlSchemaException("Wrong class type for antisense rna reference: " + result.getClass().getName());
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:hypothetical")) {
                result.setHypothetical(this.getNodeValue(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:name")) {
                result.setName(this.decodeName(this.getNodeValue(node)));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:state")) {
                SpeciesState state = this.parseXmlSpeciesState(node);
                this.processStateDataInSpecies(result, state);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:speciesIdentity: " + node.getNodeName());
        }
        return new Pair<String, Species>(identifier, result);
    }

    private void processStateDataInSpecies(Species species, SpeciesState state) {
        if (species instanceof ComplexSpecies) {
            ComplexSpecies complex = (ComplexSpecies)species;
            complex.setHomodimer(state.getHomodimer());
            complex.setStructuralState(state.getStructuralState());
            if (state.getModifications() != null && state.getModifications().size() != 0) {
                throw new NotImplementedException("Modification not supported in Complex");
            }
        } else if (species instanceof Gene) {
            Gene gene = (Gene)species;
            if (state.getStructuralState() != null) {
                throw new NotImplementedException("StructuralState not supported in Gene");
            }
            for (ModificationResidue mr : state.getModifications()) {
                gene.addModificationResidue(mr);
            }
        } else if (species instanceof Protein) {
            Protein protein = (Protein)species;
            protein.setHomodimer(state.getHomodimer());
            protein.setStructuralState(state.getStructuralState());
            for (ModificationResidue mr : state.getModifications()) {
                protein.addModificationResidue(mr);
            }
        } else if (species instanceof Rna) {
            Rna rna = (Rna)species;
            if (state.getHomodimer() != 1) {
                throw new NotImplementedException("Invalid dimer value for RNA: " + state.getHomodimer());
            }
            if (state.getStructuralState() != null && !state.getStructuralState().trim().equals("")) {
                throw new NotImplementedException("Structural state not supported in RNA");
            }
            if (state.getModifications() != null) {
                for (ModificationResidue mr : state.getModifications()) {
                    rna.addRegion(this.createRnaRegion(mr));
                }
            }
        } else if (species instanceof SimpleMolecule) {
            SimpleMolecule simpleMolecule = (SimpleMolecule)species;
            simpleMolecule.setHomodimer(state.getHomodimer());
            if (state.getStructuralState() != null && !state.getStructuralState().trim().equals("")) {
                throw new NotImplementedException("Structural state not supported in SimpleMolecule");
            }
            if (state.getModifications() != null && state.getModifications().size() != 0) {
                throw new NotImplementedException("Modification not supported in SimpleMolecule");
            }
        } else if (species instanceof AntisenseRna) {
            AntisenseRna antisenseRna = (AntisenseRna)species;
            if (state.getHomodimer() != 1) {
                throw new NotImplementedException("Invalid dimer value for RNA: " + state.getHomodimer());
            }
            if (state.getStructuralState() != null && !state.getStructuralState().trim().equals("")) {
                throw new NotImplementedException("Structural state not supported in AntisenseRna");
            }
            if (state.getModifications() != null) {
                for (ModificationResidue mr : state.getModifications()) {
                    AntisenseRnaRegion region = this.createAntisenseRnaRegion(mr);
                    antisenseRna.addRegion(region);
                }
            }
        } else {
            throw new NotImplementedException("Species state data are not implemented for " + species.getClass() + " class");
        }
    }

    private SpeciesState parseXmlSpeciesState(Node stateNode) {
        NodeList nodes = stateNode.getChildNodes();
        SpeciesState result = new SpeciesState();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node structureNode;
            int y;
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:homodimer")) {
                result.setHomodimer(this.getNodeValue(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfStructuralStates")) {
                NodeList structureNodeList = node.getChildNodes();
                for (y = 0; y < structureNodeList.getLength(); ++y) {
                    structureNode = structureNodeList.item(y);
                    if (structureNode.getNodeType() != 1) continue;
                    if (structureNode.getNodeName().equalsIgnoreCase("celldesigner:structuralState")) {
                        String state = this.getNodeAttr("structuralState", structureNode);
                        result.setStructuralState(state);
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfStructuralStates: " + node.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfModifications")) {
                NodeList modificationNodeList = node.getChildNodes();
                for (y = 0; y < modificationNodeList.getLength(); ++y) {
                    structureNode = modificationNodeList.item(y);
                    if (structureNode.getNodeType() != 1) continue;
                    if (structureNode.getNodeName().equalsIgnoreCase("celldesigner:modification")) {
                        ModificationResidue modification = this.getSpeciesModification(structureNode);
                        result.addModificationResidue(modification);
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfModifications: " + node.getNodeName());
                }
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:state: " + node.getNodeName());
        }
        return result;
    }

    private ModificationResidue getSpeciesModification(Node rootNode) {
        ModificationResidue modification = new ModificationResidue();
        modification.setIdModificationResidue(this.getNodeAttr("residue", rootNode));
        String state = this.getNodeAttr("state", rootNode);
        if (state == null) {
            state = this.getNodeAttr("type", rootNode);
        }
        if (state != null) {
            ModificationState mState = ModificationState.getByName(state);
            if (mState == null) {
                throw new InvalidArgumentException("Unknown modification state: " + state);
            }
            modification.setState(mState);
        }
        modification.setName(this.getNodeAttr("name", rootNode));
        modification.setSize(this.getNodeAttr("size", rootNode));
        modification.setAngle(this.getNodeAttr("pos", rootNode));
        NodeList list = rootNode.getChildNodes();
        for (int y = 0; y < list.getLength(); ++y) {
            Node node = list.item(y);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:modification: " + node.getNodeName());
        }
        return modification;
    }

    private String modificationResidueToXml(ModificationResidue mr) {
        String state = "";
        if (mr.getState() != null) {
            state = mr.getState().getFullName();
        }
        if (state == null || state.equals("")) {
            return "";
        }
        return "<celldesigner:modification residue=\"" + mr.getIdModificationResidue() + "\" state=\"" + state + "\"> </celldesigner:modification>\n";
    }

    private AntisenseRnaRegion createAntisenseRnaRegion(ModificationResidue mr) {
        AntisenseRnaRegion region = new AntisenseRnaRegion();
        region.setIdAntisenseRnaRegion(mr.getIdModificationResidue());
        if (mr.getSize() != null) {
            region.setSize(mr.getSize());
        }
        region.setState(mr.getState());
        region.setName(mr.getName());
        if (mr.getAngle() != null) {
            region.setPos(mr.getAngle());
        }
        return region;
    }

    public RnaRegion createRnaRegion(ModificationResidue mr) {
        RnaRegion result = new RnaRegion();
        result.setIdRnaRegion(mr.getIdModificationResidue());
        if (mr.getSize() != null) {
            result.setSize(mr.getSize());
        }
        result.setState(mr.getState());
        result.setName(mr.getName());
        if (mr.getAngle() != null) {
            result.setPos(mr.getAngle());
        }
        return result;
    }
}

