/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.species.GenericProtein;
import lcsb.mapviewer.model.map.species.IonChannelProtein;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.ReceptorProtein;
import lcsb.mapviewer.model.map.species.TruncatedProtein;

public enum ProteinMapping {
    GENERIC_PROTEIN(GenericProtein.class, "GENERIC"),
    ION_CHANNEL_PROTEIN(IonChannelProtein.class, "ION_CHANNEL"),
    RECEPTOR_PROTEIN(ReceptorProtein.class, "RECEPTOR"),
    TRUNCATED_PROTEIN(TruncatedProtein.class, "TRUNCATED");

    private String cellDesignerString;
    private Class<? extends Protein> clazz;

    private ProteinMapping(Class<? extends Protein> clazz, String cellDesignerString) {
        this.cellDesignerString = cellDesignerString;
        this.clazz = clazz;
    }

    public String getCellDesignerString() {
        return this.cellDesignerString;
    }

    public Class<? extends Protein> getClazz() {
        return this.clazz;
    }

    public static ProteinMapping getMappingByString(String string) {
        for (ProteinMapping mapping : ProteinMapping.values()) {
            if (!mapping.getCellDesignerString().equals(string)) continue;
            return mapping;
        }
        return null;
    }

    public static ProteinMapping getMappingByClass(Class<? extends Protein> searchClazz) {
        for (ProteinMapping mapping : ProteinMapping.values()) {
            if (!mapping.getClazz().isAssignableFrom(searchClazz)) continue;
            return mapping;
        }
        return null;
    }

    public Protein createProtein() {
        try {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidStateException(e);
        }
    }
}

