/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.ArrayList;
import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.InconsistentModelException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractElementXmlParser<T extends Element>
extends XmlParser {
    private Logger logger = Logger.getLogger(AbstractElementXmlParser.class.getName());
    private List<Pair<String, String>> encodedStrings = new ArrayList<Pair<String, String>>();
    private RestAnnotationParser rap = new RestAnnotationParser();

    public abstract Pair<String, T> parseXmlElement(Node var1, List<String> var2) throws InvalidXmlSchemaException;

    protected AbstractElementXmlParser() {
        this.encodedStrings.add(new Pair<String, String>("_BR_", "\n"));
        this.encodedStrings.add(new Pair<String, String>("_br_", "\n"));
        this.encodedStrings.add(new Pair<String, String>("_plus_", "+"));
        this.encodedStrings.add(new Pair<String, String>("_minus_", "-"));
        this.encodedStrings.add(new Pair<String, String>("_slash_", "/"));
        this.encodedStrings.add(new Pair<String, String>("_underscore_", "_"));
        this.encodedStrings.add(new Pair<String, String>("_space_", " "));
        this.encodedStrings.add(new Pair<String, String>("_Alpha_", "\u0391"));
        this.encodedStrings.add(new Pair<String, String>("_alpha_", "\u03b1"));
        this.encodedStrings.add(new Pair<String, String>("_Beta_", "\u0392"));
        this.encodedStrings.add(new Pair<String, String>("_beta_", "\u03b2"));
        this.encodedStrings.add(new Pair<String, String>("_Gamma_", "\u0393"));
        this.encodedStrings.add(new Pair<String, String>("_gamma_", "\u03b3"));
        this.encodedStrings.add(new Pair<String, String>("_Delta_", "\u0394"));
        this.encodedStrings.add(new Pair<String, String>("_delta_", "\u03b4"));
        this.encodedStrings.add(new Pair<String, String>("_Epsilon_", "\u0395"));
        this.encodedStrings.add(new Pair<String, String>("_epsilon_", "\u03b5"));
        this.encodedStrings.add(new Pair<String, String>("_Zeta_", "\u0396"));
        this.encodedStrings.add(new Pair<String, String>("_zeta_", "\u03b6"));
        this.encodedStrings.add(new Pair<String, String>("_Eta_", "\u0397"));
        this.encodedStrings.add(new Pair<String, String>("_eta_", "\u03b7"));
        this.encodedStrings.add(new Pair<String, String>("_Theta_", "\u0398"));
        this.encodedStrings.add(new Pair<String, String>("_theta_", "\u03b8"));
        this.encodedStrings.add(new Pair<String, String>("_Iota_", "\u0399"));
        this.encodedStrings.add(new Pair<String, String>("_iota_", "\u03b9"));
        this.encodedStrings.add(new Pair<String, String>("_Kappa_", "\u039a"));
        this.encodedStrings.add(new Pair<String, String>("_kappa_", "\u03ba"));
        this.encodedStrings.add(new Pair<String, String>("_Lambda_", "\u039b"));
        this.encodedStrings.add(new Pair<String, String>("_lambda_", "\u03bb"));
        this.encodedStrings.add(new Pair<String, String>("_Mu_", "\u039c"));
        this.encodedStrings.add(new Pair<String, String>("_mu_", "\u03bc"));
        this.encodedStrings.add(new Pair<String, String>("_Nu_", "\u039d"));
        this.encodedStrings.add(new Pair<String, String>("_nu_", "\u03bd"));
        this.encodedStrings.add(new Pair<String, String>("_Xi_", "\u039e"));
        this.encodedStrings.add(new Pair<String, String>("_xi_", "\u03be"));
        this.encodedStrings.add(new Pair<String, String>("_Omicron_", "\u039f"));
        this.encodedStrings.add(new Pair<String, String>("_omicron_", "\u03bf"));
        this.encodedStrings.add(new Pair<String, String>("_Pi_", "\u03a0"));
        this.encodedStrings.add(new Pair<String, String>("_pi_", "\u03c0"));
        this.encodedStrings.add(new Pair<String, String>("_Rho_", "\u03a1"));
        this.encodedStrings.add(new Pair<String, String>("_rho_", "\u03c1"));
        this.encodedStrings.add(new Pair<String, String>("_Sigma_", "\u03a3"));
        this.encodedStrings.add(new Pair<String, String>("_sigma_", "\u03c3"));
        this.encodedStrings.add(new Pair<String, String>("_Tau_", "\u03a4"));
        this.encodedStrings.add(new Pair<String, String>("_tau_", "\u03c4"));
        this.encodedStrings.add(new Pair<String, String>("_Upsilon_", "\u03a5"));
        this.encodedStrings.add(new Pair<String, String>("_upsilon_", "\u03c5"));
        this.encodedStrings.add(new Pair<String, String>("_Phi_", "\u03a6"));
        this.encodedStrings.add(new Pair<String, String>("_phi_", "\u03c6"));
        this.encodedStrings.add(new Pair<String, String>("_Chi_", "\u03a7"));
        this.encodedStrings.add(new Pair<String, String>("_chi_", "\u03c7"));
        this.encodedStrings.add(new Pair<String, String>("_Psi_", "\u03a8"));
        this.encodedStrings.add(new Pair<String, String>("_psi_", "\u03c8"));
        this.encodedStrings.add(new Pair<String, String>("_Omega_", "\u03a9"));
        this.encodedStrings.add(new Pair<String, String>("_omega_", "\u03c9"));
    }

    public Pair<String, T> parseXmlElement(String xmlString, List<String> warnings) throws InvalidXmlSchemaException {
        Document doc = this.getXmlDocumentFromString(xmlString);
        NodeList root = doc.getChildNodes();
        if (root.getLength() != 1) {
            throw new InvalidXmlSchemaException("Invalid number of children in the xml string!");
        }
        return this.parseXmlElement(root.item(0), warnings);
    }

    public abstract String toXml(T var1) throws InconsistentModelException;

    protected String decodeName(String name) {
        String result = name;
        for (Pair<String, String> pair : this.encodedStrings) {
            result = result.replaceAll(pair.getLeft(), pair.getRight());
        }
        return result;
    }

    protected RestAnnotationParser getRap() {
        return this.rap;
    }

    protected void setRap(RestAnnotationParser rap) {
        this.rap = rap;
    }
}

