/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.reaction;

import java.util.HashMap;
import java.util.Map;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.graphics.ArrowType;
import lcsb.mapviewer.model.graphics.LineType;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.BooleanLogicGateReaction;
import lcsb.mapviewer.model.map.reaction.type.DissociationReaction;
import lcsb.mapviewer.model.map.reaction.type.HeterodimerAssociationReaction;
import lcsb.mapviewer.model.map.reaction.type.KnownTransitionOmittedReaction;
import lcsb.mapviewer.model.map.reaction.type.NegativeInfluenceReaction;
import lcsb.mapviewer.model.map.reaction.type.PhysicalStimulationReaction;
import lcsb.mapviewer.model.map.reaction.type.PositiveInfluenceReaction;
import lcsb.mapviewer.model.map.reaction.type.ReducedModulationReaction;
import lcsb.mapviewer.model.map.reaction.type.ReducedPhysicalStimulationReaction;
import lcsb.mapviewer.model.map.reaction.type.ReducedTriggerReaction;
import lcsb.mapviewer.model.map.reaction.type.StateTransitionReaction;
import lcsb.mapviewer.model.map.reaction.type.TranscriptionReaction;
import lcsb.mapviewer.model.map.reaction.type.TranslationReaction;
import lcsb.mapviewer.model.map.reaction.type.TransportReaction;
import lcsb.mapviewer.model.map.reaction.type.TriggerReaction;
import lcsb.mapviewer.model.map.reaction.type.TruncationReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownNegativeInfluenceReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownPositiveInfluenceReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownReducedModulationReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownReducedPhysicalStimulationReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownReducedTriggerReaction;
import lcsb.mapviewer.model.map.reaction.type.UnknownTransitionReaction;

public enum ReactionLineData {
    BOOLEAN_LOGIC_GATE(BooleanLogicGateReaction.class, "BOOLEAN_LOGIC_GATE"),
    DISSOCIATION(DissociationReaction.class, "DISSOCIATION"),
    HETERODIMER_ASSOCIATION(HeterodimerAssociationReaction.class, "HETERODIMER_ASSOCIATION"),
    KNOWN_TRANSITION_OMITTED(KnownTransitionOmittedReaction.class, "KNOWN_TRANSITION_OMITTED"),
    NEGATIVE_INFLUENCE(NegativeInfluenceReaction.class, "NEGATIVE_INFLUENCE", LineType.SOLID, ArrowType.CROSSBAR, 3.0),
    PHYSICAL_STIMULATION(PhysicalStimulationReaction.class, "PHYSICAL_STIMULATION", LineType.SOLID, ArrowType.BLANK),
    POSITIVE_INFLUENCE(PositiveInfluenceReaction.class, "POSITIVE_INFLUENCE", LineType.SOLID, ArrowType.OPEN),
    REDUCED_MODULATION(ReducedModulationReaction.class, "REDUCED_MODULATION", LineType.SOLID, ArrowType.BLANK),
    REDUCED_PHYSICAL_STIMULATION(ReducedPhysicalStimulationReaction.class, "REDUCED_PHYSICAL_STIMULATION", LineType.DASHED, ArrowType.BLANK),
    REDUCED_TRIGGER(ReducedTriggerReaction.class, "REDUCED_TRIGGER", LineType.SOLID, ArrowType.CROSSBAR),
    STATE_TRANSITION(StateTransitionReaction.class, "STATE_TRANSITION"),
    TRANSCRIPTION(TranscriptionReaction.class, "TRANSCRIPTION", LineType.DASH_DOT_DOT),
    TRANSLATION(TranslationReaction.class, "TRANSLATION", LineType.DASH_DOT),
    TRANSPORT(TransportReaction.class, "TRANSPORT", LineType.SOLID, ArrowType.FULL_CROSSBAR),
    TRIGGER(TriggerReaction.class, "TRIGGER", LineType.SOLID, ArrowType.BLANK_CROSSBAR),
    TRUNCATION(TruncationReaction.class, "TRUNCATION"),
    UNKNOWN_NEGATIVE_INFLUENCE(UnknownNegativeInfluenceReaction.class, "UNKNOWN_NEGATIVE_INFLUENCE", LineType.DASHED, ArrowType.CROSSBAR, 3.0),
    UNKNOWN_POSITIVE_INFLUENCE(UnknownPositiveInfluenceReaction.class, "UNKNOWN_POSITIVE_INFLUENCE", LineType.DASHED, ArrowType.OPEN),
    UNKNOWN_REDUCED_MODEULATION(UnknownReducedModulationReaction.class, "UNKNOWN_REDUCED_MODULATION", LineType.DASHED, ArrowType.DIAMOND),
    UNKNOWN_REDUCED_PHYSICAL_STIMULATION(UnknownReducedPhysicalStimulationReaction.class, "UNKNOWN_REDUCED_PHYSICAL_STIMULATION", LineType.DASHED, ArrowType.BLANK),
    UNKNOWN_REDUCED_TRIGGER(UnknownReducedTriggerReaction.class, "UNKNOWN_REDUCED_TRIGGER", LineType.DASHED, ArrowType.BLANK_CROSSBAR),
    UNKNOWN_TRANSITION(UnknownTransitionReaction.class, "UNKNOWN_TRANSITION");

    private Class<? extends Reaction> reactionClass;
    private ArrowType productArrowType;
    private LineType lineType;
    private double productLineTrim;
    private String cellDesignerString;
    private static Map<Class<? extends Reaction>, ReactionLineData> map;
    private static Map<String, ReactionLineData> cellDesignerMap;

    private ReactionLineData(Class<? extends Reaction> clazz, String cellDesignerString) {
        this(clazz, cellDesignerString, LineType.SOLID);
    }

    private ReactionLineData(Class<? extends Reaction> clazz, String cellDesignerString, LineType lineType) {
        this(clazz, cellDesignerString, lineType, ArrowType.FULL);
    }

    private ReactionLineData(Class<? extends Reaction> clazz, String cellDesignerString, LineType lineType, ArrowType productArrowType) {
        this(clazz, cellDesignerString, lineType, productArrowType, 0.0);
    }

    private ReactionLineData(Class<? extends Reaction> clazz, String cellDesignerString, LineType lineType, ArrowType productArrowType, double productLineTrim) {
        this.reactionClass = clazz;
        this.lineType = lineType;
        this.productArrowType = productArrowType;
        this.productLineTrim = productLineTrim;
        this.cellDesignerString = cellDesignerString;
    }

    public Class<? extends Reaction> getReactionClass() {
        return this.reactionClass;
    }

    public ArrowType getProductArrowType() {
        return this.productArrowType;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public double getProductLineTrim() {
        return this.productLineTrim;
    }

    public static ReactionLineData getByReactionType(Class<? extends Reaction> clazz) {
        if (map == null) {
            map = new HashMap<Class<? extends Reaction>, ReactionLineData>();
            for (ReactionLineData rld : ReactionLineData.values()) {
                map.put(rld.getReactionClass(), rld);
            }
        }
        return map.get(clazz);
    }

    public String getCellDesignerString() {
        return this.cellDesignerString;
    }

    public static ReactionLineData getByCellDesignerString(String type) {
        if (cellDesignerMap == null) {
            cellDesignerMap = new HashMap<String, ReactionLineData>();
            for (ReactionLineData rld : ReactionLineData.values()) {
                cellDesignerMap.put(rld.getCellDesignerString(), rld);
            }
        }
        return cellDesignerMap.get(type);
    }

    public Reaction createReaction(Reaction result) {
        try {
            return this.reactionClass.getConstructor(Reaction.class).newInstance(result);
        }
        catch (Exception e) {
            throw new InvalidArgumentException("[" + this.name() + "] Problem with creation the new instance of REaction for: " + result + ". ");
        }
    }

    static {
        map = null;
        cellDesignerMap = null;
    }
}

