/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.reaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.reaction.ReactionXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.reaction.UnknownReactionClassException;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.reaction.Reaction;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReactionCollectionXmlParser
extends XmlParser {
    private Logger logger = Logger.getLogger(ReactionCollectionXmlParser.class.getName());
    private Model model = null;
    private ReactionXmlParser xmlStructureFactory = new ReactionXmlParser();

    public ReactionCollectionXmlParser(Model model) {
        this.model = model;
    }

    public List<Reaction> parseXmlReactionCollection(Node reactionsNode) throws InvalidXmlSchemaException, UnknownReactionClassException {
        ArrayList<Reaction> result = new ArrayList<Reaction>();
        NodeList nodes = reactionsNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("reaction")) {
                Reaction reaction = this.xmlStructureFactory.getReaction(node, this.model);
                result.add(reaction);
                continue;
            }
            this.logger.debug("Unknown element of model/listOfReactions: " + node.getNodeName());
        }
        return result;
    }

    public String reactionCollectionToXmlString(Collection<Reaction> collection) {
        String result = "";
        result = result + "<listOfReactions>\n";
        for (Reaction reaction : collection) {
            result = result + this.xmlStructureFactory.toXml(reaction);
        }
        result = result + "</listOfReactions>\n";
        return result;
    }
}

