/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry.helper;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import org.apache.log4j.Logger;

public class CellDesignerPolygonTransformation {
    private static Logger logger = Logger.getLogger(CellDesignerPolygonTransformation.class.getName());

    private Point2D getMidPoint(Point2D pointA, Point2D pointB) {
        return new Point2D.Double((pointA.getX() + pointB.getX()) / 2.0, (pointA.getY() + pointB.getY()) / 2.0);
    }

    public Point2D getPointOnPolygonByAnchor(ArrayList<Point2D> points, CellDesignerAnchor anchor) {
        if (points.size() == 8) {
            return this.getPointOn8NodesPolygonByAnchor(points, anchor);
        }
        if (points.size() == 16) {
            return this.getPointOn16NodesPolygonByAnchor(points, anchor);
        }
        logger.error("Invalid number of points: " + points.size());
        return this.copyPoint(points.get(0));
    }

    private Point2D copyPoint(Point2D point) {
        return new Point2D.Double(point.getX(), point.getY());
    }

    private Point2D getPointOn8NodesPolygonByAnchor(ArrayList<Point2D> points, CellDesignerAnchor anchor) {
        if (anchor == null || anchor.getAngle() == null) {
            logger.error("Invalid anchor: " + (Object)((Object)anchor));
            return this.copyPoint(points.get(0));
        }
        int position = (anchor.ordinal() + 8) % 16;
        if (position % 2 == 0) {
            return this.copyPoint(points.get(position / 2));
        }
        return this.getMidPoint(points.get(position / 2), points.get((position / 2 + 1) % 8));
    }

    private Point2D getPointOn16NodesPolygonByAnchor(ArrayList<Point2D> points, CellDesignerAnchor anchor) {
        if (anchor == null || anchor.getAngle() == null) {
            logger.error("Invalid anchor: " + (Object)((Object)anchor));
            return this.copyPoint(points.get(0));
        }
        int position = (anchor.ordinal() + 8) % 16;
        return this.copyPoint(points.get(position));
    }
}

