/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry.helper;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.geometry.LineTransformation;
import lcsb.mapviewer.model.graphics.PolylineData;
import org.apache.log4j.Logger;

public class CellDesignerLineTransformation
extends LineTransformation {
    private static Logger logger = Logger.getLogger(CellDesignerLineTransformation.class.getName());

    public List<Point2D> getLinePointsFromPoints(Point2D startPoint, Point2D endPoint, List<Point2D> midPoints) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        double dx1 = endPoint.getX() - startPoint.getX();
        double dy1 = endPoint.getY() - startPoint.getY();
        double dx2 = -dy1;
        double dy2 = dx1;
        result.add(startPoint);
        if (midPoints != null) {
            for (Point2D p : midPoints) {
                double x = startPoint.getX() + dx1 * p.getX() + dx2 * p.getY();
                double y = startPoint.getY() + dy1 * p.getX() + dy2 * p.getY();
                result.add(new Point2D.Double(x, y));
            }
        }
        result.add(endPoint);
        return result;
    }

    public List<Point2D> getPointsFromLine(PolylineData line) {
        if (line == null) {
            throw new InvalidArgumentException("Line cannot be null.");
        }
        if (line.getPoints().size() < 2) {
            throw new InvalidArgumentException("Invalid line passed as an argument.");
        }
        double ax = line.getBeginPoint().getX();
        double ay = line.getBeginPoint().getY();
        double bx = line.getEndPoint().getX();
        double by = line.getEndPoint().getY();
        double dx = bx - ax;
        double dy = by - ay;
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 1; i < line.getPoints().size() - 1; ++i) {
            double ox = line.getPoints().get(i).getX();
            double oy = line.getPoints().get(i).getY();
            double py = (dy * (ax - ox) + dx * (oy - ay)) / (dy * dy + dx * dx);
            double px = (ox - ax) / dx + dy / dx * py;
            result.add(new Point2D.Double(px, py));
        }
        return result;
    }
}

