/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AbstractCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;

public class DrugCellDesignerAliasConverter
extends AbstractCellDesignerAliasConverter<SpeciesAlias> {
    private static final int RECTANGLE_CORNER_ARC_SIZE = 40;

    @Override
    public Point2D getPointCoordinates(SpeciesAlias alias, CellDesignerAnchor anchor) {
        if (this.invalidAnchorPosition(alias, anchor)) {
            return alias.getCenter();
        }
        ArrayList<Point2D> list = this.getDrugPoints(alias);
        return this.getPolygonTransformation().getPointOnPolygonByAnchor(list, anchor);
    }

    @Override
    protected PathIterator getBoundPathIterator(SpeciesAlias alias) {
        return this.getDrugShape(alias).getPathIterator(new AffineTransform());
    }

    protected ArrayList<Point2D> getDrugPoints(SpeciesAlias alias) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        double x = alias.getX();
        double y = alias.getY();
        double width = alias.getWidth();
        double height = alias.getHeight();
        list.add(new Point2D.Double(x, y + height / 2.0));
        list.add(new Point2D.Double(x + width / 12.0, y));
        list.add(new Point2D.Double(x + width / 2.0, y));
        list.add(new Point2D.Double(x + width * 11.0 / 12.0, y));
        list.add(new Point2D.Double(x + width, y + height / 2.0));
        list.add(new Point2D.Double(x + width * 11.0 / 12.0, y + height));
        list.add(new Point2D.Double(x + width / 2.0, y + height));
        list.add(new Point2D.Double(x + width / 12.0, y + height));
        return list;
    }

    private Shape getDrugShape(Alias alias) {
        return new RoundRectangle2D.Double(alias.getX(), alias.getY(), alias.getWidth(), alias.getHeight(), 40.0, 40.0);
    }
}

