/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AntisenseRnaCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.ComplexCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.DegradedCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.DrugCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.GeneCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.ICellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.IonCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.PhenotypeCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.ProteinCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.RnaCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.SimpleMoleculeCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.UnknownCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Degraded;
import lcsb.mapviewer.model.map.species.Drug;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.GenericProtein;
import lcsb.mapviewer.model.map.species.Ion;
import lcsb.mapviewer.model.map.species.IonChannelProtein;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.ReceptorProtein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.TruncatedProtein;
import lcsb.mapviewer.model.map.species.Unknown;

public class CellDesignerAliasConverter
implements ICellDesignerAliasConverter<Alias> {
    private static Map<Class<? extends Element>, ICellDesignerAliasConverter<?>> elementConverters = new HashMap();
    private static Map<Class<? extends Alias>, ICellDesignerAliasConverter<?>> aliasConverters = new HashMap();
    private ICellDesignerAliasConverter converter = null;

    protected static void addElementConverter(Class<? extends Element> clazz, ICellDesignerAliasConverter<?> converter) {
        elementConverters.put(clazz, converter);
    }

    protected static void addAliasConverter(Class<? extends Alias> clazz, ICellDesignerAliasConverter<?> converter) {
        aliasConverters.put(clazz, converter);
    }

    private static ICellDesignerAliasConverter<? extends Alias> getConverterForAlias(Alias alias) {
        if (alias == null) {
            throw new InvalidArgumentException("alias cannot be null");
        }
        ICellDesignerAliasConverter<?> result = null;
        Element element = alias.getElement();
        if (element != null) {
            result = elementConverters.get(element.getClass());
        }
        if (result == null) {
            result = aliasConverters.get(alias.getClass());
        }
        return result;
    }

    public CellDesignerAliasConverter(Alias alias) {
        this.converter = CellDesignerAliasConverter.getConverterForAlias(alias);
        if (this.converter == null) {
            String message = "Unknown converter for class: " + alias.getClass() + "(" + alias.getAliasId() + ")";
            if (alias.getElement() != null) {
                message = message + " and element: " + alias.getElement().getClass() + "(" + alias.getElement().getElementId() + ")";
            }
            throw new InvalidArgumentException(message);
        }
    }

    @Override
    public CellDesignerAnchor getAnchorForCoordinates(Alias alias, Point2D point) {
        return this.converter.getAnchorForCoordinates(alias, point);
    }

    @Override
    public Point2D getPointCoordinates(Alias alias, CellDesignerAnchor anchor) {
        return this.converter.getPointCoordinates(alias, anchor);
    }

    @Override
    public Point2D getAnchorPointCoordinates(Alias alias, CellDesignerAnchor anchor, PolylineData line) {
        return this.converter.getAnchorPointCoordinates(alias, anchor, line);
    }

    static {
        CellDesignerAliasConverter.addElementConverter(GenericProtein.class, new ProteinCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(TruncatedProtein.class, new ProteinCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(ReceptorProtein.class, new ProteinCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(IonChannelProtein.class, new ProteinCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Degraded.class, new DegradedCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(ComplexSpecies.class, new ComplexCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(SimpleMolecule.class, new SimpleMoleculeCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Drug.class, new DrugCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Ion.class, new IonCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Phenotype.class, new PhenotypeCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Rna.class, new RnaCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(AntisenseRna.class, new AntisenseRnaCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Gene.class, new GeneCellDesignerAliasConverter());
        CellDesignerAliasConverter.addElementConverter(Unknown.class, new UnknownCellDesignerAliasConverter());
    }
}

