/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.compartment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.compartment.CompartmentXmlParser;
import lcsb.mapviewer.model.map.agregator.Compartment;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompartmentCollectionXmlParser
extends XmlParser {
    private Logger logger = Logger.getLogger(CompartmentCollectionXmlParser.class.getName());
    private CompartmentXmlParser compartmentParser = new CompartmentXmlParser();

    public List<Compartment> parseXmlCompartmentCollection(Node compartmentsNode) throws InvalidXmlSchemaException {
        ArrayList<Compartment> result = new ArrayList<Compartment>();
        CompartmentXmlParser compartmentParser = new CompartmentXmlParser();
        NodeList nodes = compartmentsNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("compartment")) {
                Pair<String, Compartment> compartmentPair = compartmentParser.parseXmlElement(node, null);
                result.add(compartmentPair.getRight());
                continue;
            }
            this.logger.debug("Unknown element of model/listOfCompartments: " + node.getNodeName());
        }
        return result;
    }

    public String toXml(Collection<Compartment> collection) {
        String result = "";
        result = result + "<listOfCompartments>\n";
        for (Compartment compartment : collection) {
            result = result + this.compartmentParser.toXml(compartment);
        }
        result = result + "</listOfCompartments>\n";
        return result;
    }
}

