/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.annotation;

import lcsb.mapviewer.model.map.AnnotatedObject;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamType;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.Species;

public enum NoteField {
    HGNC("HGNC_ID", AnnotatedObject.class, MiriamType.HGNC),
    REFSEQ("RefSeq_ID", AnnotatedObject.class, MiriamType.REFSEQ),
    ENTREZ("EntrezGene_ID", AnnotatedObject.class, MiriamType.ENTREZ),
    REACTOME("Reactome_ID", AnnotatedObject.class, MiriamType.REACTOME),
    PUBMED("Pubmed_ID", AnnotatedObject.class, MiriamType.PUBMED),
    KEGG_GENES("KEGG_ID", AnnotatedObject.class, MiriamType.KEGG_GENES),
    PANTHER("PANTHER", AnnotatedObject.class, MiriamType.PANTHER),
    SYMBOL("Symbol", Element.class, null),
    NAME("Name", Element.class, null),
    DESCRIPTION("Description", AnnotatedObject.class, null),
    PREVIOUS_SYMBOLS("Previous Symbols", Element.class, null),
    SYNONYMS("Synonyms", AnnotatedObject.class, null),
    ABBREVIATION("Abbreviation", AnnotatedObject.class, null),
    FORMULA("Formula", Reaction.class, null),
    MECHANICAL_CONFIDENCE_SCORE("MechanicalConfidenceScore", Reaction.class, null),
    LOWER_BOUND("LowerBound", Reaction.class, null),
    UPPER_BOUND("UpperBound", Reaction.class, null),
    SUBSYSTEM("Subsystem", Reaction.class, null),
    GENE_PROTEIN_REACTION("GeneProteinReaction", Reaction.class, null),
    CHARGED_FORMULA("ChargedFormula", Element.class, null),
    CHARGE("Charge", Species.class, null);

    private String commonName;
    private Class<? extends AnnotatedObject> clazz;
    private MiriamType miriamType;

    private NoteField(String name, Class<? extends AnnotatedObject> clazz) {
        this.commonName = name;
        this.clazz = clazz;
    }

    private NoteField(String name, Class<? extends AnnotatedObject> clazz, MiriamType type) {
        this(name, clazz);
        this.miriamType = type;
    }

    public MiriamType getMiriamType() {
        return this.miriamType;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public Class<? extends AnnotatedObject> getClazz() {
        return this.clazz;
    }
}

