/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.alias;

import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.alias.AbstractAliasXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.structure.View;
import lcsb.mapviewer.model.map.layout.alias.ArtifitialCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeciesAliasXmlParser
extends AbstractAliasXmlParser<SpeciesAlias> {
    private Logger logger = Logger.getLogger(SpeciesAliasXmlParser.class.getName());
    private Model model = null;

    public SpeciesAliasXmlParser(Model model) {
        this.model = model;
    }

    @Override
    SpeciesAlias parseXmlAlias(Node aliasNode) throws InvalidXmlSchemaException {
        String complexAliasId;
        SpeciesAlias result = new SpeciesAlias();
        result.setAliasId(this.getNodeAttr("id", aliasNode));
        String speciesId = this.getNodeAttr("species", aliasNode);
        Species species = this.model.getSpeciesBySpeciesId(speciesId);
        if (species == null) {
            throw new InvalidXmlSchemaException("Unknown species for alias (speciesId: " + speciesId + ")");
        }
        result.setSpecies(species);
        String state = "usual";
        NodeList nodes = aliasNode.getChildNodes();
        View usualView = null;
        View briefView = null;
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:activity")) {
                result.setActivity(this.getNodeValue(node).equalsIgnoreCase("active"));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                result.setX(this.getNodeAttr("X", node));
                result.setY(this.getNodeAttr("Y", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:font")) {
                result.setFontSize(this.getNodeAttr("size", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:view")) {
                state = this.getNodeAttr("state", node);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:usualView")) {
                usualView = this.getCommonParser().getView(node);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:briefView")) {
                briefView = this.getCommonParser().getView(node);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:info") || node.getNodeName().equalsIgnoreCase("celldesigner:structuralState")) continue;
            this.logger.debug("Unknown element of celldesigner:speciesAlias: " + node.getNodeName());
        }
        View view = null;
        if (state.equalsIgnoreCase("usual")) {
            view = usualView;
        } else if (state.equalsIgnoreCase("brief")) {
            view = briefView;
        }
        if (view != null) {
            result.setWidth(view.getBoxSize().width);
            result.setHeight(view.getBoxSize().height);
            result.setLineWidth(view.getSingleLine().getWidth());
            result.setColor(view.getColor());
        } else {
            this.logger.error("No view in Alias");
        }
        result.setState(state);
        String compartmentAliasId = this.getNodeAttr("compartmentAlias", aliasNode);
        if (!compartmentAliasId.equals("")) {
            CompartmentAlias ca = this.model.getCompartmentAliasByCompartmentAliasId(compartmentAliasId);
            if (ca == null) {
                this.logger.error("CompartmentAlias does not exist: " + compartmentAliasId);
            } else {
                result.setParent(ca);
            }
        }
        if (!(complexAliasId = this.getNodeAttr("complexSpeciesAlias", aliasNode)).equals("")) {
            ComplexAlias alias = (ComplexAlias)this.model.getAliasByAliasId(complexAliasId);
            if (alias == null) {
                this.logger.error("ComplexAlias does not exist: " + complexAliasId + ", current: " + result.getAliasId());
            } else {
                result.setParent(alias);
                alias.addAlias(result);
            }
        }
        return result;
    }

    @Override
    public String toXml(SpeciesAlias alias) {
        ModelData model;
        Species species = alias.getSpecies();
        CompartmentAlias ca = null;
        if (alias.getParent() instanceof CompartmentAlias && !(alias.getParent() instanceof ArtifitialCompartmentAlias)) {
            ca = (CompartmentAlias)alias.getParent();
        } else if (alias.getComplexAlias() == null && (model = alias.getModelData()) != null) {
            for (CompartmentAlias cAlias : model.getModel().getCompartmentsAliases()) {
                if (cAlias instanceof ArtifitialCompartmentAlias || !cAlias.cross(alias)) continue;
                if (ca == null) {
                    ca = cAlias;
                    continue;
                }
                if (!(ca.getSize() > cAlias.getSize())) continue;
                ca = cAlias;
            }
        }
        ComplexAlias complexAlias = null;
        if (alias.getParent() instanceof ComplexAlias) {
            complexAlias = (ComplexAlias)alias.getParent();
        }
        String compartmentAliasId = null;
        if (ca != null) {
            compartmentAliasId = ca.getAliasId();
        }
        StringBuilder sb = new StringBuilder("");
        sb.append("<celldesigner:speciesAlias ");
        sb.append("id=\"" + alias.getAliasId() + "\" ");
        sb.append("species=\"" + species.getIdSpecies() + "\" ");
        if (compartmentAliasId != null) {
            sb.append("compartmentAlias=\"" + compartmentAliasId + "\" ");
        }
        if (complexAlias != null) {
            sb.append("complexSpeciesAlias=\"" + complexAlias.getAliasId() + "\" ");
        }
        sb.append(">\n");
        if (alias.getActivity() != null) {
            if (alias.getActivity().booleanValue()) {
                sb.append("<celldesigner:activity>active</celldesigner:activity>\n");
            } else {
                sb.append("<celldesigner:activity>inactive</celldesigner:activity>\n");
            }
        }
        sb.append("<celldesigner:bounds ");
        sb.append("x=\"" + alias.getX() + "\" ");
        sb.append("y=\"" + alias.getY() + "\" ");
        sb.append("w=\"" + alias.getWidth() + "\" ");
        sb.append("h=\"" + alias.getHeight() + "\" ");
        sb.append("/>\n");
        sb.append("<celldesigner:font size=\"" + alias.getFontSize() + "\"/>\n");
        sb.append("<celldesigner:view state=\"usual\"/>\n");
        sb.append("<celldesigner:usualView>");
        sb.append("<celldesigner:innerPosition x=\"" + alias.getX() + "\" y=\"" + alias.getY() + "\"/>");
        sb.append("<celldesigner:boxSize width=\"" + alias.getWidth() + "\" height=\"" + alias.getHeight() + "\"/>");
        sb.append("<celldesigner:singleLine width=\"" + alias.getLineWidth() + "\"/>");
        sb.append("<celldesigner:paint color=\"" + this.colorToString(alias.getColor()) + "\" scheme=\"Color\"/>");
        sb.append("</celldesigner:usualView>\n");
        sb.append("<celldesigner:briefView>");
        sb.append("<celldesigner:innerPosition x=\"" + alias.getX() + "\" y=\"" + alias.getY() + "\"/>");
        sb.append("<celldesigner:boxSize width=\"" + alias.getWidth() + "\" height=\"" + alias.getHeight() + "\"/>");
        sb.append("<celldesigner:singleLine width=\"" + alias.getLineWidth() + "\"/>");
        sb.append("<celldesigner:paint color=\"" + this.colorToString(alias.getColor()) + "\" scheme=\"Color\"/>");
        sb.append("</celldesigner:briefView>\n");
        sb.append("</celldesigner:speciesAlias>\n");
        return sb.toString();
    }
}

