/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.alias;

import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.alias.AbstractAliasXmlParser;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.layout.alias.BottomSquareCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.LeftSquareCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.OvalCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.RightSquareCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.SquareCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.TopSquareCompartmentAlias;
import lcsb.mapviewer.model.map.model.Model;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompartmentAliasXmlParser
extends AbstractAliasXmlParser<CompartmentAlias> {
    private Logger logger = Logger.getLogger(CompartmentAliasXmlParser.class.getName());
    private Model model = null;

    public CompartmentAliasXmlParser(Model model) {
        this.model = model;
    }

    @Override
    CompartmentAlias parseXmlAlias(Node aliasNode) throws InvalidXmlSchemaException {
        CompartmentAlias result = new CompartmentAlias();
        String compartmentId = this.getNodeAttr("compartment", aliasNode);
        Compartment compartment = this.model.getCompartmentByCompartmentId(compartmentId);
        if (compartment == null) {
            throw new InvalidXmlSchemaException("Compartment does not exist in a model: " + compartmentId);
        }
        result.setCompartment(compartment);
        result.setAliasId(this.getNodeAttr("id", aliasNode));
        NodeList nodes = aliasNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:class")) {
                String type = this.getNodeValue(node);
                if (type.equalsIgnoreCase("SQUARE")) {
                    result = new SquareCompartmentAlias(result);
                    continue;
                }
                if (type.equalsIgnoreCase("SQUARE_CLOSEUP_NORTH")) {
                    result = new BottomSquareCompartmentAlias(result, this.model);
                    continue;
                }
                if (type.equalsIgnoreCase("SQUARE_CLOSEUP_SOUTH")) {
                    result = new TopSquareCompartmentAlias(result, this.model);
                    continue;
                }
                if (type.equalsIgnoreCase("SQUARE_CLOSEUP_WEST")) {
                    result = new RightSquareCompartmentAlias(result, this.model);
                    continue;
                }
                if (type.equalsIgnoreCase("SQUARE_CLOSEUP_EAST")) {
                    result = new LeftSquareCompartmentAlias(result, this.model);
                    continue;
                }
                if (type.equalsIgnoreCase("OVAL")) {
                    result = new OvalCompartmentAlias(result);
                    continue;
                }
                this.logger.debug("Unknown compartment type: " + type);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                result.setX(this.getNodeAttr("x", node));
                result.setY(this.getNodeAttr("y", node));
                result.setWidth(this.getNodeAttr("w", node));
                result.setHeight(this.getNodeAttr("h", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:doubleLine")) {
                result.setLineThickness(this.getNodeAttr("thickness", node));
                result.setLineOuterWidth(this.getNodeAttr("outerWidth", node));
                result.setLineInnerWidth(this.getNodeAttr("innerWidth", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:paint")) {
                result.setColor(this.getCommonParser().getColor(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:info")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:point")) {
                if (result instanceof BottomSquareCompartmentAlias) {
                    result.setY(this.getNodeAttr("y", node));
                    continue;
                }
                if (result instanceof LeftSquareCompartmentAlias) {
                    result.setX(this.getNodeAttr("x", node));
                    continue;
                }
                if (result instanceof RightSquareCompartmentAlias) {
                    result.setX(this.getNodeAttr("x", node));
                    result.setWidth(result.getWidth() - result.getX());
                    continue;
                }
                if (result instanceof TopSquareCompartmentAlias) {
                    result.setY(this.getNodeAttr("y", node));
                    continue;
                }
                throw new InvalidArgumentException("Don't know what to do with celldesigner:point for class: " + result.getClass());
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:namePoint")) {
                result.setNamePoint(this.getCommonParser().getPosition(node));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:compartmentAlias: " + node.getNodeName());
        }
        return result;
    }

    @Override
    public String toXml(CompartmentAlias alias) {
        Compartment compartment = alias.getCompartment();
        StringBuilder sb = new StringBuilder("");
        sb.append("<celldesigner:compartmentAlias ");
        sb.append("id=\"" + alias.getAliasId() + "\" ");
        sb.append("compartment=\"" + compartment.getCompartmentId() + "\">\n");
        boolean bounds = true;
        if (alias.getClass().getName().equals(SquareCompartmentAlias.class.getName())) {
            sb.append("<celldesigner:class>SQUARE</celldesigner:class>\n");
        } else if (alias.getClass().getName().equals(OvalCompartmentAlias.class.getName())) {
            sb.append("<celldesigner:class>OVAL</celldesigner:class>\n");
        } else if (alias.getClass().getName().equals(LeftSquareCompartmentAlias.class.getName())) {
            sb.append("<celldesigner:class>SQUARE_CLOSEUP_EAST</celldesigner:class>\n");
            bounds = false;
            sb.append("<celldesigner:point x=\"" + alias.getWidth() + "\" y=\"10\"/>");
        } else if (alias.getClass().getName().equals(RightSquareCompartmentAlias.class.getName())) {
            sb.append("<celldesigner:class>SQUARE_CLOSEUP_WEST</celldesigner:class>\n");
            bounds = false;
            sb.append("<celldesigner:point x=\"" + alias.getX() + "\" y=\"10\"/>");
        } else {
            this.logger.warn("Unknown compartment class: " + alias.getClass());
        }
        if (bounds) {
            sb.append("<celldesigner:bounds ");
            sb.append("x=\"" + alias.getX() + "\" ");
            sb.append("y=\"" + alias.getY() + "\" ");
            sb.append("w=\"" + alias.getWidth() + "\" ");
            sb.append("h=\"" + alias.getHeight() + "\"/>\n");
        }
        sb.append("<celldesigner:namePoint ");
        sb.append("x=\"" + alias.getNamePoint().getX() + "\" ");
        sb.append("y=\"" + alias.getNamePoint().getY() + "\"/>\n");
        sb.append("<celldesigner:doubleLine ");
        sb.append("thickness=\"" + alias.getThickness() + "\" ");
        sb.append("outerWidth=\"" + alias.getOuterWidth() + "\" ");
        sb.append("innerWidth=\"" + alias.getInnerWidth() + "\"/>\n");
        sb.append("<celldesigner:paint ");
        sb.append("color=\"" + this.colorToString(alias.getColor()) + "\" scheme=\"Color\"/>\n");
        sb.append("</celldesigner:compartmentAlias>\n");
        return sb.toString();
    }
}

