/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.CommonXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.InvalidGroupException;
import lcsb.mapviewer.model.graphics.ArrowType;
import lcsb.mapviewer.model.graphics.LineType;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasGroup;
import lcsb.mapviewer.model.map.layout.alias.BlockDiagram;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.layout.graphics.LayerOval;
import lcsb.mapviewer.model.map.layout.graphics.LayerRect;
import lcsb.mapviewer.model.map.layout.graphics.LayerText;
import lcsb.mapviewer.model.map.model.Model;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerXmlParser
extends XmlParser {
    private Logger logger = Logger.getLogger(LayerXmlParser.class.getName());
    private CommonXmlParser commonParser = new CommonXmlParser();

    public Collection<Layer> parseLayers(Node layersNode) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        NodeList nodes = layersNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:layer")) {
                Layer layer = this.getLayer(node);
                result.add(layer);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfLayers: " + node.getNodeName());
        }
        return result;
    }

    public String layerCollectionToXml(Collection<Layer> layers) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:listOfLayers>");
        for (Layer layer : layers) {
            result.append(this.layerToXml(layer));
        }
        result.append("</celldesigner:listOfLayers>\n");
        return result.toString();
    }

    public void parseBlocks(Model model, Node xmlNode) {
        NodeList nodes = xmlNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:blockDiagram")) {
                model.addBlockDiagream(this.getBlockDiagram(node, model));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfBlockDiagrams: " + node.getNodeName());
        }
    }

    private BlockDiagram getBlockDiagram(Node node, Model model) {
        return null;
    }

    public void parseGroups(Model model, Node xmlNode) throws InvalidXmlSchemaException {
        NodeList nodes = xmlNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:group")) {
                model.addAliasGroup(this.getAliasGroup(node, model));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfGroups: " + node.getNodeName());
        }
    }

    AliasGroup getAliasGroup(Node groupNode, Model model) throws InvalidGroupException {
        String[] list;
        AliasGroup result = new AliasGroup();
        String id = this.getNodeAttr("id", groupNode);
        result.setIdGroup(id);
        String members = this.getNodeAttr("members", groupNode);
        for (String string : list = members.split(",")) {
            Alias alias = model.getAliasByAliasId(string);
            if (alias == null) {
                throw new InvalidGroupException("Group \"" + id + "\" contains alias with id: \"" + string + "\", but such alias doesn't exist in the model.");
            }
            result.addAlias(alias);
        }
        NodeList nodes = groupNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:group: " + node.getNodeName());
        }
        return result;
    }

    Layer getLayer(Node layerNode) {
        Layer layer = new Layer();
        layer.setLayerId(this.getNodeAttr("id", layerNode));
        layer.setName(this.getNodeAttr("name", layerNode));
        layer.setLocked(this.getNodeAttr("locked", layerNode));
        layer.setVisible(this.getNodeAttr("visible", layerNode));
        NodeList list = layerNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node textNode;
            int j;
            NodeList residueList;
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:listOfTexts")) {
                residueList = node.getChildNodes();
                for (j = 0; j < residueList.getLength(); ++j) {
                    textNode = residueList.item(j);
                    if (textNode.getNodeType() != 1) continue;
                    if (textNode.getNodeName().equalsIgnoreCase("celldesigner:layerSpeciesAlias")) {
                        layer.addLayerText(this.getLayerText(textNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfTexts " + textNode.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfSquares")) {
                residueList = node.getChildNodes();
                for (j = 0; j < residueList.getLength(); ++j) {
                    textNode = residueList.item(j);
                    if (textNode.getNodeType() != 1) continue;
                    if (textNode.getNodeName().equalsIgnoreCase("celldesigner:layerCompartmentAlias")) {
                        if (this.getNodeAttr("type", textNode).equalsIgnoreCase("SQUARE")) {
                            layer.addLayerRect(this.getLayerRect(textNode));
                            continue;
                        }
                        if (this.getNodeAttr("type", textNode).equalsIgnoreCase("OVAL")) {
                            layer.addLayerOval(this.getLayerOval(textNode));
                            continue;
                        }
                        this.logger.debug("Unknown celldesigner:layerCompartmentAlias type: " + this.getNodeAttr("type", textNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfSquares " + textNode.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfFreeLines")) {
                residueList = node.getChildNodes();
                for (j = 0; j < residueList.getLength(); ++j) {
                    textNode = residueList.item(j);
                    if (textNode.getNodeType() != 1) continue;
                    if (textNode.getNodeName().equalsIgnoreCase("celldesigner:layerFreeLine")) {
                        layer.addLayerLine(this.getLayerLine(textNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfSquares " + textNode.getNodeName());
                }
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:layer " + node.getNodeName());
        }
        return layer;
    }

    String layerToXml(Layer layer) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:layer id =\"" + layer.getLayerId() + "\" ");
        result.append(" name =\"" + layer.getName() + "\" ");
        result.append(" locked =\"" + layer.isLocked() + "\" ");
        result.append(" visible =\"" + layer.isVisible() + "\">\n");
        result.append("<celldesigner:listOfTexts>\n");
        for (LayerText layerText : layer.getTexts()) {
            result.append(this.layerTextToXml(layerText));
        }
        result.append("</celldesigner:listOfTexts>\n");
        result.append("<celldesigner:listOfSquares>\n");
        for (LayerRect layerRect : layer.getRectangles()) {
            result.append(this.layerRectToXml(layerRect));
        }
        for (LayerOval layerOval : layer.getOvals()) {
            result.append(this.layerOvalToXml(layerOval));
        }
        result.append("</celldesigner:listOfSquares>\n");
        result.append("<celldesigner:listOfFreeLines>\n");
        for (PolylineData layerLine : layer.getLines()) {
            result.append(this.layerLineToXml(layerLine));
        }
        result.append("</celldesigner:listOfFreeLines>\n");
        result.append("</celldesigner:layer>\n");
        return result.toString();
    }

    LayerRect getLayerRect(Node textNode) {
        LayerRect result = new LayerRect();
        NodeList nodes = textNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:paint")) {
                result.setColor(this.commonParser.getColor(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                result.setX(this.getNodeAttr("x", node));
                result.setY(this.getNodeAttr("y", node));
                result.setWidth(this.getNodeAttr("w", node));
                result.setHeight(this.getNodeAttr("h", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:ispaint")) continue;
            this.logger.debug("Unknown element of celldesigner:layerSpeciesAlias: " + node.getNodeName());
        }
        return result;
    }

    String layerRectToXml(LayerRect layer) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:layerCompartmentAlias type=\"Square\">");
        result.append("<celldesigner:paint color=\"" + this.colorToString(layer.getColor()) + "\"/>");
        result.append("<celldesigner:bounds x=\"" + layer.getX() + "\" ");
        result.append(" y=\"" + layer.getY() + "\" ");
        result.append(" w=\"" + layer.getWidth() + "\" ");
        result.append(" h=\"" + layer.getHeight() + "\"/>");
        result.append("</celldesigner:layerCompartmentAlias>");
        return result.toString();
    }

    PolylineData getLayerLine(Node lineNode) {
        PolylineData ld = new PolylineData();
        if (this.getNodeAttr("isDotted", lineNode).equalsIgnoreCase("true")) {
            ld.getEndAtd().setArrowLineType(LineType.DOTTED);
        }
        if (this.getNodeAttr("isArrow", lineNode).equalsIgnoreCase("true")) {
            ld.getEndAtd().setArrowType(ArrowType.FULL);
        }
        NodeList nodes = lineNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                double sx = Double.parseDouble(this.getNodeAttr("sx", node));
                double sy = Double.parseDouble(this.getNodeAttr("sy", node));
                double ex = Double.parseDouble(this.getNodeAttr("ex", node));
                double ey = Double.parseDouble(this.getNodeAttr("ey", node));
                Point2D.Double startPoint = new Point2D.Double(sx, sy);
                Point2D.Double endPoint = new Point2D.Double(ex, ey);
                ld.addPoint(startPoint);
                ld.addPoint(endPoint);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:line")) {
                ld.setColor(this.stringToColor(this.getNodeAttr("color", node)));
                ld.setWidth(this.getNodeAttr("width", node));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:layerSpeciesAlias: " + node.getNodeName());
        }
        return ld;
    }

    String layerLineToXml(PolylineData layer) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:layerFreeLine ");
        result.append(" isDotted=\"" + layer.getEndAtd().getArrowLineType().equals((Object)LineType.DOTTED) + "\" ");
        result.append(" isArrow=\"" + layer.getEndAtd().getArrowType().equals((Object)ArrowType.FULL) + "\" >");
        result.append("<celldesigner:bounds sx=\"" + layer.getBeginPoint().getX() + "\" ");
        result.append(" sy=\"" + layer.getBeginPoint().getY() + "\" ");
        result.append(" ex=\"" + layer.getEndPoint().getX() + "\" ");
        result.append(" ey=\"" + layer.getEndPoint().getY() + "\" />");
        result.append("<celldesigner:line ");
        result.append(" width=\"" + layer.getWidth() + "\" ");
        result.append(" color=\"" + this.colorToString(layer.getColor()) + "\"/>");
        result.append("</celldesigner:layerFreeLine>\n");
        return result.toString();
    }

    LayerOval getLayerOval(Node textNode) {
        LayerOval result = new LayerOval();
        NodeList nodes = textNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:paint")) {
                result.setColor(this.commonParser.getColor(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                result.setX(this.getNodeAttr("x", node));
                result.setY(this.getNodeAttr("y", node));
                result.setWidth(this.getNodeAttr("w", node));
                result.setHeight(this.getNodeAttr("h", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:ispaint")) continue;
            this.logger.debug("Unknown element of celldesigner:layerSpeciesAlias: " + node.getNodeName());
        }
        return result;
    }

    String layerOvalToXml(LayerOval layer) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:layerCompartmentAlias type=\"Oval\">");
        result.append("<celldesigner:paint color=\"" + this.colorToString(layer.getColor()) + "\"/>");
        result.append("<celldesigner:bounds x=\"" + layer.getX() + "\" ");
        result.append(" y=\"" + layer.getY() + "\" ");
        result.append(" w=\"" + layer.getWidth() + "\" ");
        result.append(" h=\"" + layer.getHeight() + "\"/>");
        result.append("</celldesigner:layerCompartmentAlias>");
        return result.toString();
    }

    LayerText getLayerText(Node textNode) {
        LayerText result = new LayerText();
        NodeList nodes = textNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:layerNotes")) {
                result.setNotes(this.getNodeValue(node).trim());
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:paint")) {
                result.setColor(this.commonParser.getColor(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:bounds")) {
                result.setX(this.getNodeAttr("x", node));
                result.setY(this.getNodeAttr("y", node));
                result.setWidth(this.getNodeAttr("w", node));
                result.setHeight(this.getNodeAttr("h", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:font")) {
                result.setFontSize(this.getNodeAttr("size", node));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:layerSpeciesAlias: " + node.getNodeName());
        }
        return result;
    }

    String layerTextToXml(LayerText layer) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:layerSpeciesAlias>");
        result.append("<celldesigner:layerNotes>\n");
        result.append(super.escapeXml(layer.getNotes()));
        result.append("\n</celldesigner:layerNotes>");
        result.append("<celldesigner:paint color=\"" + this.colorToString(layer.getColor()) + "\"/>");
        result.append("<celldesigner:bounds x=\"" + layer.getX() + "\" ");
        result.append(" y=\"" + layer.getY() + "\" ");
        result.append(" w=\"" + layer.getWidth() + "\" ");
        result.append(" h=\"" + layer.getHeight() + "\"/>");
        result.append("<celldesigner:font size=\"" + layer.getFontSize() + "\"/>");
        result.append("</celldesigner:layerSpeciesAlias>\n");
        return result.toString();
    }
}

