/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.converter.model.celldesigner.structure.SingleLine;
import lcsb.mapviewer.converter.model.celldesigner.structure.View;
import org.w3c.dom.Node;

public class CommonXmlParser
extends XmlParser {
    public Point2D getPosition(Node node) {
        double x = Double.parseDouble(this.getNodeAttr("x", node));
        double y = Double.parseDouble(this.getNodeAttr("y", node));
        return new Point2D.Double(x, y);
    }

    public Dimension getDimension(Node node) {
        double width = Double.parseDouble(this.getNodeAttr("width", node));
        double height = Double.parseDouble(this.getNodeAttr("height", node));
        Dimension result = new Dimension();
        result.setSize(width, height);
        return result;
    }

    public SingleLine getSingleLine(Node node) {
        SingleLine result = new SingleLine();
        result.setWidth(Double.parseDouble(this.getNodeAttr("width", node)));
        return result;
    }

    public Color getColor(Node node) {
        String color = this.getNodeAttr("color", node);
        return this.stringToColor(color);
    }

    public View getView(Node node) {
        View result = new View();
        Node tmpNode = this.getNode("celldesigner:innerPosition", node.getChildNodes());
        if (tmpNode != null) {
            result.setInnerPosition(this.getPosition(tmpNode));
        }
        if ((tmpNode = this.getNode("celldesigner:boxSize", node.getChildNodes())) != null) {
            result.setBoxSize(this.getDimension(tmpNode));
        }
        if ((tmpNode = this.getNode("celldesigner:singleLine", node.getChildNodes())) != null) {
            result.setSingleLine(this.getSingleLine(tmpNode));
        }
        if ((tmpNode = this.getNode("celldesigner:paint", node.getChildNodes())) != null) {
            result.setColor(this.getColor(tmpNode));
        }
        return result;
    }
}

