/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lcsb.mapviewer.common.ExceptionConverter;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.ConverterParams;
import lcsb.mapviewer.converter.IConverter;
import lcsb.mapviewer.converter.InvalidInputDataExecption;
import lcsb.mapviewer.converter.model.celldesigner.LayerXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.alias.AliasCollectionXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.compartment.CompartmentCollectionXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.reaction.ReactionCollectionXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.reaction.UnknownReactionClassException;
import lcsb.mapviewer.converter.model.celldesigner.species.InternalModelSpeciesData;
import lcsb.mapviewer.converter.model.celldesigner.species.SpeciesCollectionXmlParser;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.InconsistentModelException;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.layout.graphics.LayerOval;
import lcsb.mapviewer.model.map.layout.graphics.LayerRect;
import lcsb.mapviewer.model.map.layout.graphics.LayerText;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelFullIndexed;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CellDesignerXmlParser
extends XmlParser
implements IConverter {
    private Logger logger = Logger.getLogger(CellDesignerXmlParser.class.getName());
    private LayerXmlParser layerParser = new LayerXmlParser();
    private CompartmentCollectionXmlParser compartmentCollectionXmlParser = new CompartmentCollectionXmlParser();
    private SpeciesCollectionXmlParser speciesSbmlParser;
    private AliasCollectionXmlParser aliasCollectionParser;

    @Override
    public Model createModel(ConverterParams params) throws InvalidInputDataExecption {
        ModelFullIndexed model = new ModelFullIndexed(null);
        if (params.getFilename() != null) {
            model.setName(FilenameUtils.getBaseName(params.getFilename()));
        }
        this.speciesSbmlParser = new SpeciesCollectionXmlParser(model);
        this.aliasCollectionParser = new AliasCollectionXmlParser(model);
        DOMParser parser = new DOMParser();
        try {
            parser.parse(params.getSource());
        }
        catch (IOException e) {
            this.logger.error(ExceptionConverter.exceptionToString(e));
            throw new InvalidInputDataExecption("IO Problem with a file: " + params.getSource().getSystemId());
        }
        Document doc = parser.getDocument();
        try {
            NodeList root = doc.getChildNodes();
            Node sbmlNode = this.getNode("SBML", root);
            if (sbmlNode == null) {
                throw new InvalidInputDataExecption("No SBML node");
            }
            Node modelNode = this.getNode("model", sbmlNode.getChildNodes());
            if (modelNode == null) {
                throw new InvalidInputDataExecption("No model node in SBML");
            }
            model.setMetaId(this.getNodeAttr("metaId", modelNode));
            model.setIdModel(this.getNodeAttr("id", modelNode));
            Node compartmentNode = this.getNode("listOfCompartments", modelNode.getChildNodes());
            if (compartmentNode != null) {
                List<Compartment> compartments = this.compartmentCollectionXmlParser.parseXmlCompartmentCollection(compartmentNode);
                model.addCompartments(compartments);
            }
            InternalModelSpeciesData modelData = new InternalModelSpeciesData();
            Node speciesNode = this.getNode("listOfSpecies", modelNode.getChildNodes());
            if (speciesNode != null) {
                List<String> warnings = new ArrayList<String>();
                List<Pair<String, ? extends Species>> species = this.speciesSbmlParser.parseSbmlSpeciesCollection(speciesNode, warnings);
                model.addCreationWarnings(warnings);
                warnings = modelData.updateSpecies(species);
                model.addCreationWarnings(warnings);
            }
            Node reactionsNode = null;
            NodeList nodes = modelNode.getChildNodes();
            for (int x = 0; x < nodes.getLength(); ++x) {
                Node node = nodes.item(x);
                if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("annotation") || node.getNodeName().equalsIgnoreCase("listOfSpecies")) continue;
                if (node.getNodeName().equalsIgnoreCase("listOfReactions")) {
                    reactionsNode = node;
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("listOfCompartments")) continue;
                if (node.getNodeName().equalsIgnoreCase("notes")) {
                    RestAnnotationParser rap = new RestAnnotationParser();
                    String notes = rap.getNotes(node);
                    if (notes != null) {
                        notes = StringEscapeUtils.unescapeHtml4(notes);
                    }
                    model.setNotes(notes);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("listOfUnitDefinitions")) continue;
                this.logger.debug("Unknown element of model: " + node.getNodeName());
            }
            Node annotationNode = this.getNode("annotation", modelNode.getChildNodes());
            if (annotationNode == null) {
                throw new InvalidInputDataExecption("No annotation node in SBML/model");
            }
            this.parseAnnotation(model, annotationNode, modelData);
            if (speciesNode != null) {
                ArrayList<String> warnings = new ArrayList<String>();
                List<Pair<String, ? extends Species>> species = this.speciesSbmlParser.parseSbmlSpeciesCollection(speciesNode, warnings);
                model.addCreationWarnings(warnings);
                modelData.updateSpecies(species);
            }
            if (reactionsNode != null) {
                ReactionCollectionXmlParser reactionCollectionXmlParser = new ReactionCollectionXmlParser(model);
                List<Reaction> reactions = reactionCollectionXmlParser.parseXmlReactionCollection(reactionsNode);
                model.addReactions(reactions);
            }
            if (params.isSizeAutoAdjust()) {
                Rectangle2D bound = this.getModelBound(model);
                double width = bound.getWidth() + 2.0 * bound.getX();
                double height = bound.getHeight() + 2.0 * bound.getY();
                model.setWidth(width);
                model.setHeight(height);
            }
        }
        catch (InvalidXmlSchemaException e) {
            throw new InvalidInputDataExecption(e);
        }
        catch (UnknownReactionClassException e) {
            String type = e.getReactionType();
            String reactionId = e.getReactionId();
            String newType = null;
            if ("CATALYSIS".equalsIgnoreCase(type)) {
                newType = "positive influence";
            } else if ("INHIBITION".equalsIgnoreCase(type)) {
                newType = "negative influence";
            } else if ("UNKNOWN_CATALYSIS".equalsIgnoreCase(type)) {
                newType = "unknown positive influence";
            } else if ("UNKNOWN_INHIBITION".equalsIgnoreCase(type)) {
                newType = "unknown negative influence";
            } else if ("PHYSICAL_STIMULATION".equalsIgnoreCase(type)) {
                newType = "reduced physical stimulation";
            } else if ("MODULATION".equalsIgnoreCase(type)) {
                newType = "reduced modulation";
            } else if ("TRIGGER".equalsIgnoreCase(type)) {
                newType = "reduced trigger";
            } else {
                throw new InvalidInputDataExecption(e);
            }
            throw new InvalidInputDataExecption("Reaction type \"" + type + "\" is inappropriate for reaction " + reactionId + ". Suggested type: " + newType + " in the \"Reduced\" notation of CellDesigner.", e);
        }
        return model;
    }

    private Rectangle2D getModelBound(Model model) {
        double maxX = 0.0;
        double maxY = 0.0;
        double minX = model.getWidth();
        double minY = model.getHeight();
        for (Alias alias : model.getAliases()) {
            maxX = Math.max(maxX, alias.getWidth() + alias.getX());
            maxY = Math.max(maxY, alias.getHeight() + alias.getY());
            minX = Math.min(minX, alias.getX());
            minY = Math.min(minY, alias.getY());
        }
        for (Reaction reaction : model.getReactions()) {
            for (Line2D line : reaction.getLines()) {
                maxX = Math.max(maxX, line.getX1());
                maxX = Math.max(maxX, line.getX2());
                maxY = Math.max(maxY, line.getY1());
                maxY = Math.max(maxY, line.getY2());
                minX = Math.min(minX, line.getX1());
                minX = Math.min(minX, line.getX2());
                minY = Math.min(minY, line.getY1());
                minY = Math.min(minY, line.getY2());
            }
        }
        for (Layer layer : model.getLayers()) {
            for (PolylineData lline : layer.getLines()) {
                for (Line2D line : lline.getLines()) {
                    maxX = Math.max(maxX, line.getX1());
                    maxX = Math.max(maxX, line.getX2());
                    maxY = Math.max(maxY, line.getY1());
                    maxY = Math.max(maxY, line.getY2());
                    minX = Math.min(minX, line.getX1());
                    minX = Math.min(minX, line.getX2());
                    minY = Math.min(minY, line.getY1());
                    minY = Math.min(minY, line.getY2());
                }
            }
            for (LayerRect rect : layer.getRectangles()) {
                maxX = Math.max(maxX, rect.getX());
                maxX = Math.max(maxX, rect.getX() + rect.getWidth());
                maxY = Math.max(maxY, rect.getY());
                maxY = Math.max(maxY, rect.getY() + rect.getHeight());
                minX = Math.min(minX, rect.getX());
                minX = Math.min(minX, rect.getX() + rect.getWidth());
                minY = Math.min(minY, rect.getY());
                minY = Math.min(minY, rect.getY() + rect.getHeight());
            }
            for (LayerOval oval : layer.getOvals()) {
                maxX = Math.max(maxX, oval.getX());
                maxX = Math.max(maxX, oval.getX() + oval.getWidth());
                maxY = Math.max(maxY, oval.getY());
                maxY = Math.max(maxY, oval.getY() + oval.getHeight());
                minX = Math.min(minX, oval.getX());
                minX = Math.min(minX, oval.getX() + oval.getWidth());
                minY = Math.min(minY, oval.getY());
                minY = Math.min(minY, oval.getY() + oval.getHeight());
            }
            for (LayerText text : layer.getTexts()) {
                maxX = Math.max(maxX, text.getX());
                maxX = Math.max(maxX, text.getX() + text.getWidth());
                maxY = Math.max(maxY, text.getY());
                maxY = Math.max(maxY, text.getY() + text.getHeight());
                minX = Math.min(minX, text.getX());
                minX = Math.min(minX, text.getX() + text.getWidth());
                minY = Math.min(minY, text.getY());
                minY = Math.min(minY, text.getY() + text.getHeight());
            }
        }
        Rectangle2D.Double result = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        return result;
    }

    private void parseAnnotation(Model model, Node annotationNode, InternalModelSpeciesData modelData) throws InvalidXmlSchemaException {
        List<SpeciesAlias> aliases;
        SpeciesCollectionXmlParser parser = new SpeciesCollectionXmlParser(model);
        Node extensionNode = this.getNode("celldesigner:extension", annotationNode.getChildNodes());
        if (extensionNode == null) {
            throw new InvalidXmlSchemaException("No celldesigner:extension node in SBML/model/annotation");
        }
        NodeList nodes = extensionNode.getChildNodes();
        Node includedSpecies = null;
        Node listofSpeciesAlias = null;
        Node listOfComplexSpeciesAlias = null;
        Node listOfComparmentAlias = null;
        Node listOfProteins = null;
        Node listOfGenes = null;
        Node listOfRnas = null;
        Node listOfGroups = null;
        Node listOfAntisenseRnas = null;
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("celldesigner:modelVersion")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:modelDisplay")) {
                model.setWidth(this.getNodeAttr("sizeX", node));
                model.setHeight(this.getNodeAttr("sizeY", node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfSpeciesAliases")) {
                listofSpeciesAlias = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfComplexSpeciesAliases")) {
                listOfComplexSpeciesAlias = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfProteins")) {
                listOfProteins = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfGenes")) {
                listOfGenes = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfRNAs")) {
                listOfRnas = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfAntisenseRNAs")) {
                listOfAntisenseRnas = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfIncludedSpecies")) {
                includedSpecies = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfCompartmentAliases")) {
                listOfComparmentAlias = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfLayers")) {
                model.addLayers(this.layerParser.parseLayers(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfGroups")) {
                listOfGroups = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:listOfBlockDiagrams")) {
                this.layerParser.parseBlocks(model, node);
                continue;
            }
            this.logger.debug("Unknown element of annotation: " + node.getNodeName());
        }
        if (listOfComparmentAlias != null) {
            List<CompartmentAlias> aliases2 = this.aliasCollectionParser.parseXmlCompartmentAliasCollection(listOfComparmentAlias);
            model.addCompartmentAliases(aliases2);
        }
        if (includedSpecies != null) {
            ArrayList<String> warnings = new ArrayList<String>();
            List<Pair<String, ? extends Species>> list = parser.parseIncludedSpeciesCollection(includedSpecies, warnings);
            model.addCreationWarnings(warnings);
            modelData.updateSpecies(list);
            model.addCreationWarnings(warnings);
        }
        if (listOfProteins != null) {
            ArrayList<String> warnings = new ArrayList();
            List<Pair<String, ? extends Species>> list = parser.parseXmlProteinCollection(listOfProteins);
            warnings = modelData.updateSpecies(list);
            model.addCreationWarnings(warnings);
        }
        if (listOfGenes != null) {
            ArrayList<String> warnings = new ArrayList();
            List<Pair<String, ? extends Species>> list = parser.parseXmlGeneCollection(listOfGenes);
            warnings = modelData.updateSpecies(list);
            model.addCreationWarnings(warnings);
        }
        if (listOfRnas != null) {
            ArrayList<String> warnings = new ArrayList();
            List<Pair<String, ? extends Species>> list = parser.parseXmlRnaCollection(listOfRnas);
            warnings = modelData.updateSpecies(list);
            model.addCreationWarnings(warnings);
        }
        if (listOfAntisenseRnas != null) {
            ArrayList<String> warnings = new ArrayList();
            List<Pair<String, ? extends Species>> list = parser.parseXmlAntisenseRnaCollection(listOfAntisenseRnas);
            warnings = modelData.updateSpecies(list);
            model.addCreationWarnings(warnings);
        }
        for (Species species : modelData.getAll()) {
            if (!species.getIdSpecies().equals("")) {
                model.addElement(species);
                continue;
            }
            model.addCreationWarning("Species (class: " + species.getClass().getName() + ", name: " + species.getName() + ") exists in CD file, but is never instantiated. It's CellDesigner file problem.");
        }
        if (listOfComplexSpeciesAlias != null) {
            try {
                aliases = this.aliasCollectionParser.parseXmlComplexAliasCollection(listOfComplexSpeciesAlias);
                model.addAliases(aliases);
            }
            catch (InvalidArgumentException e) {
                throw new InvalidXmlSchemaException(e);
            }
        }
        if (listofSpeciesAlias != null) {
            aliases = this.aliasCollectionParser.parseXmlSpeciesAliasCollection(listofSpeciesAlias);
            try {
                model.addAliases(aliases);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                throw new InvalidXmlSchemaException(invalidArgumentException);
            }
        }
        if (includedSpecies != null) {
            this.parseAnnotationAliasesConnections(model, this.getNode("celldesigner:listOfSpeciesAliases", nodes));
            this.parseAnnotationComplexAliasesConnections(model, this.getNode("celldesigner:listOfComplexSpeciesAliases", nodes));
        }
        if (includedSpecies != null) {
            parser.addConnectionBetweenIncludedSpecies(includedSpecies);
        }
        if (listOfGroups != null) {
            this.layerParser.parseGroups(model, listOfGroups);
        }
    }

    private void parseAnnotationComplexAliasesConnections(Model model, Node aliasNode) {
        NodeList nodes = aliasNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:complexSpeciesAlias")) {
                ComplexAlias complex;
                String aliasId = this.getNodeAttr("id", node);
                String complexId = this.getNodeAttr("complexSpeciesAlias", node);
                ComplexAlias alias = (ComplexAlias)model.getAliasByAliasId(aliasId);
                if (alias == null) {
                    this.logger.debug("Alias does not exist " + aliasId);
                }
                if ((complex = (ComplexAlias)model.getAliasByAliasId(complexId)) == null) continue;
                complex.addAlias(alias);
                alias.setParent(complex);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfComplexSpeciesAliases: " + node.getNodeName());
        }
    }

    private void parseAnnotationAliasesConnections(Model model, Node aliasNode) {
        NodeList nodes = aliasNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:speciesAlias")) {
                ComplexAlias complex;
                String aliasId = this.getNodeAttr("id", node);
                String complexId = this.getNodeAttr("complexSpeciesAlias", node);
                Alias alias = model.getAliasByAliasId(aliasId);
                if (alias == null) {
                    this.logger.debug("Alias does not exist " + aliasId);
                    continue;
                }
                if (alias instanceof SpeciesAlias || (complex = (ComplexAlias)model.getAliasByAliasId(complexId)) == null) continue;
                alias.setParent(complex);
                complex.addAlias((SpeciesAlias)alias);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfSpeciesAliases: " + node.getNodeName());
        }
    }

    public String toXml(Model model) throws InconsistentModelException {
        SpeciesCollectionXmlParser speciesCollectionXmlParser = new SpeciesCollectionXmlParser(model);
        ReactionCollectionXmlParser reactionCollectionXmlParser = new ReactionCollectionXmlParser(model);
        this.aliasCollectionParser = new AliasCollectionXmlParser(model);
        StringBuilder result = new StringBuilder();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        result.append("<sbml xmlns=\"http://www.sbml.org/sbml/level2/version4\" xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\" level=\"2\" version=\"4\">\n");
        result.append("<model metaid=\"" + model.getMetaId() + "\" id=\"" + model.getIdModel() + "\">\n");
        if (model.getNotes() != null) {
            result.append("<notes>");
            result.append(this.escapeXml(model.getNotes()));
            result.append("</notes>");
        }
        result.append(this.annotationToXml(model));
        result.append(this.compartmentCollectionXmlParser.toXml(model.getCompartments()));
        result.append(speciesCollectionXmlParser.speciesCollectionToSbmlString(model.getSpecies()));
        result.append(reactionCollectionXmlParser.reactionCollectionToXmlString(model.getReactions()));
        result.append("</model>");
        result.append("</sbml>");
        return result.toString();
    }

    private String annotationToXml(Model model) {
        SpeciesCollectionXmlParser speciesCollectionXmlParser = new SpeciesCollectionXmlParser(model);
        StringBuilder result = new StringBuilder();
        result.append("<annotation>\n");
        result.append("<celldesigner:extension>\n");
        result.append("<celldesigner:modelVersion>4.0</celldesigner:modelVersion>\n");
        result.append("<celldesigner:modelDisplay sizeX=\"" + model.getWidth().intValue() + "\" sizeY=\"" + model.getHeight().intValue() + "\"/>\n");
        result.append(speciesCollectionXmlParser.speciesCollectionToXmlIncludedString(model.getSpecies()));
        result.append(this.aliasCollectionParser.compartmentAliasCollectionToXmlString(model.getCompartmentsAliases()));
        result.append(this.aliasCollectionParser.complexAliasCollectionToXmlString(model.getComplexAliases()));
        result.append(this.aliasCollectionParser.speciesAliasCollectionToXmlString(model.getSpeciesAliases()));
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        ArrayList<Gene> genes = new ArrayList<Gene>();
        ArrayList<Rna> rnas = new ArrayList<Rna>();
        ArrayList<AntisenseRna> antisenseRnas = new ArrayList<AntisenseRna>();
        for (Element element : model.getElements()) {
            if (element instanceof Protein) {
                proteins.add((Protein)element);
                continue;
            }
            if (element instanceof Gene) {
                genes.add((Gene)element);
                continue;
            }
            if (element instanceof AntisenseRna) {
                antisenseRnas.add((AntisenseRna)element);
                continue;
            }
            if (!(element instanceof Rna)) continue;
            rnas.add((Rna)element);
        }
        result.append(speciesCollectionXmlParser.proteinCollectionToXmlString(proteins));
        result.append(speciesCollectionXmlParser.geneCollectionToXmlString(genes));
        result.append(speciesCollectionXmlParser.rnaCollectionToXmlString(rnas));
        result.append(speciesCollectionXmlParser.antisenseRnaCollectionToXmlString(antisenseRnas));
        result.append(this.layerParser.layerCollectionToXml(model.getLayers()));
        result.append("</celldesigner:extension>\n");
        result.append("</annotation>\n");
        return result.toString();
    }
}

