/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.converter.ZipEntrySubmodelFile;
import lcsb.mapviewer.model.map.model.SubmodelType;

public class ComplexZipConverterParams {
    private ZipFile zipFile;
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, Boolean> roots = new HashMap<String, Boolean>();
    private Map<String, Boolean> mappingFiles = new HashMap<String, Boolean>();
    private Map<String, SubmodelType> types = new HashMap<String, SubmodelType>();

    public ComplexZipConverterParams zipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
        return this;
    }

    public ComplexZipConverterParams zipFile(String filename) throws IOException {
        this.zipFile = new ZipFile(filename);
        return this;
    }

    public ComplexZipConverterParams entry(String filename, String name, boolean root, boolean mappingFile, SubmodelType type) {
        if (filename == null) {
            throw new InvalidArgumentException("filename cannot be null");
        }
        if (name == null) {
            this.names.put(filename, filename);
        } else {
            this.names.put(filename, name);
        }
        this.roots.put(filename, root);
        this.mappingFiles.put(filename, mappingFile);
        if (type != null) {
            this.types.put(filename, type);
        } else {
            this.types.put(filename, SubmodelType.UNKNOWN);
        }
        return this;
    }

    public ComplexZipConverterParams entry(ZipEntrySubmodelFile entry) {
        return this.entry(entry.getFilename(), entry.getName(), "true".equalsIgnoreCase(entry.getRoot()), "true".equalsIgnoreCase(entry.getMapping()), entry.getType());
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public String getName(String filename) {
        return this.names.get(filename);
    }

    public Boolean isRoot(String filename) {
        return this.roots.get(filename);
    }

    public Boolean isMappingFile(String filename) {
        return this.mappingFiles.get(filename);
    }

    public SubmodelType getType(String filename) {
        return this.types.get(filename);
    }

    public Set<String> getFilenames() {
        return this.names.keySet();
    }
}

