/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.converter.ComplexZipConverterParams;
import lcsb.mapviewer.converter.ConverterParams;
import lcsb.mapviewer.converter.IConverter;
import lcsb.mapviewer.converter.InvalidInputDataExecption;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnection;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.SubmodelType;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

public class ComplexZipConverter<T extends IConverter> {
    private static Logger logger = Logger.getLogger(ComplexZipConverter.class);
    private Class<T> converterClazz;

    public ComplexZipConverter(Class<T> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new InvalidClassException("Param class cannot be abstract");
        }
        if (Modifier.isInterface(clazz.getModifiers())) {
            throw new InvalidClassException("Param class cannot be an interface");
        }
        this.converterClazz = clazz;
    }

    public Model createModel(ComplexZipConverterParams params) throws InvalidInputDataExecption {
        Model model;
        IConverter converter;
        ZipFile zipFile = params.getZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        HashSet<String> processed = new HashSet<String>();
        String root = null;
        String mapping = null;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (params.getType(name) == null) {
                throw new InvalidArgumentException("No information found in params about file: " + name);
            }
            if (params.isRoot(name).booleanValue()) {
                if (root != null) {
                    throw new InvalidArgumentException("Two roots found: " + name + ", " + root + ". There can be only one.");
                }
                root = name;
            }
            if (params.isMappingFile(name).booleanValue()) {
                if (mapping != null) {
                    throw new InvalidArgumentException("Two mapping files found: " + name + ", " + mapping + ". There can be only one.");
                }
                mapping = name;
            }
            processed.add(name);
        }
        if (root == null) {
            throw new InvalidArgumentException("No root map found.");
        }
        for (String entryName : params.getFilenames()) {
            if (processed.contains(entryName)) continue;
            throw new InvalidArgumentException("Entry " + entryName + " doesn't exists in the zip file.");
        }
        try {
            converter = (IConverter)this.converterClazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidClassException("Problem with instantation of the class: " + this.converterClazz, e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException("Problem with instantation of the class: " + this.converterClazz, e);
        }
        HashMap<String, Model> filenameModelMap = new HashMap<String, Model>();
        HashMap<String, Model> nameModelMap = new HashMap<String, Model>();
        entries = zipFile.entries();
        Model result = null;
        while (entries.hasMoreElements()) {
            InputStream inputStream;
            ZipEntry entry = entries.nextElement();
            try {
                inputStream = zipFile.getInputStream(entry);
            }
            catch (IOException e) {
                throw new InvalidInputDataExecption(e);
            }
            ConverterParams cParams = new ConverterParams();
            cParams.inputStream(inputStream);
            model = converter.createModel(cParams);
            model.setName(params.getName(entry.getName()));
            filenameModelMap.put(entry.getName(), model);
            nameModelMap.put(params.getName(entry.getName()), model);
            if (!root.equals(entry.getName())) continue;
            result = model;
        }
        for (Map.Entry entry : filenameModelMap.entrySet()) {
            String filename = (String)entry.getKey();
            model = (Model)entry.getValue();
            if (params.isRoot(filename).booleanValue() || params.isMappingFile(filename).booleanValue()) continue;
            ModelSubmodelConnection submodel = new ModelSubmodelConnection(model, params.getType(filename));
            submodel.setName(params.getName(filename));
            result.addSubmodelConnection(submodel);
        }
        Model mappingModel = (Model)filenameModelMap.get(mapping);
        if (mappingModel != null) {
            for (Reaction reaction : mappingModel.getReactions()) {
                if (reaction.getReactants().size() > 1) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains too many reactants. Skipped");
                    continue;
                }
                if (reaction.getProducts().size() > 1) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains too many products. Skipped");
                    continue;
                }
                if (reaction.getModifiers().size() > 0) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains modifiers. Skipped");
                    continue;
                }
                Alias fromAlias = reaction.getReactants().get(0).getAlias();
                Element fromElement = fromAlias.getElement();
                Alias toAlias = reaction.getProducts().get(0).getAlias();
                Element toElement = toAlias.getElement();
                if (!(fromAlias instanceof SpeciesAlias)) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains doesn't start in species. Skipped");
                    continue;
                }
                if (!(toAlias instanceof SpeciesAlias)) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains doesn't end in species. Skipped");
                    continue;
                }
                Species from = (Species)fromElement;
                ComplexAlias complexFrom = ((SpeciesAlias)fromAlias).getComplexAlias();
                Species to = (Species)toElement;
                ComplexAlias complexTo = ((SpeciesAlias)toAlias).getComplexAlias();
                if (complexFrom == null) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains doesn't start inside complex. Skipped");
                    continue;
                }
                if (complexTo == null && !(toAlias instanceof ComplexAlias)) {
                    result.addCreationWarning("[SUBMODEL MAPPING] Reaction " + reaction.getIdReaction() + " in mapping file (" + mapping + ") contains doesn't end inside complex. Skipped");
                    continue;
                }
                if (complexTo == null) {
                    complexTo = (ComplexAlias)toAlias;
                }
                String fromName = complexFrom.getElement().getName();
                String toName = complexTo.getElement().getName();
                Model fromModel = (Model)nameModelMap.get(fromName);
                Model toModel = (Model)nameModelMap.get(toName);
                if (fromModel == null) {
                    throw new InvalidArgumentException("Mapping file references to " + fromName + " submodel. But such model doesn't exist");
                }
                if (toModel == null) {
                    throw new InvalidArgumentException("Mapping file references to " + toName + " submodel. But such model doesn't exist");
                }
                Alias source = fromModel.getAliasByAliasId(from.getName());
                Alias dest = null;
                if (!(toAlias instanceof ComplexAlias)) {
                    dest = fromModel.getAliasByAliasId(to.getName());
                }
                SubmodelType type = SubmodelType.UNKNOWN;
                if (from instanceof Protein) {
                    type = SubmodelType.DOWNSTREAM_TARGETS;
                } else if (from instanceof Phenotype) {
                    type = SubmodelType.PATHWAY;
                }
                AliasSubmodelConnection connection = new AliasSubmodelConnection(toModel, type);
                connection.setFromAlias(source);
                connection.setToAlias(dest);
                connection.setName(toModel.getName());
                source.setSubmodel(connection);
            }
        }
        return result;
    }
}

