/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.common.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class LineTransformation {
    private static final int SEG_CUBICTO_END_Y_COORDINATE_INDEX = 5;
    private static final int SEG_CUBICTO_END_X_COORDINATE_INDEX = 4;
    private static final int PATH_ITERATOR_COORDINATES_STRUCT_SIZE = 6;
    private static Logger logger = Logger.getLogger(LineTransformation.class.getName());

    public Point2D getIntersectionWithPathIterator(Line2D line, PathIterator pi) {
        if (pi == null) {
            return null;
        }
        double[] coordinates = new double[6];
        Point2D.Double first = null;
        Point2D.Double last = null;
        Point2D.Double actual = null;
        while (!pi.isDone()) {
            double y4;
            double x4;
            double y3;
            double x3;
            double y2;
            double x2;
            double y1;
            double x1;
            int type = pi.currentSegment(coordinates);
            last = actual;
            actual = new Point2D.Double(coordinates[0], coordinates[1]);
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    actual = new Point2D.Double(coordinates[4], coordinates[5]);
                    break;
                }
                case 4: {
                    actual = first;
                    break;
                }
            }
            if (first == null) {
                first = actual;
            } else if (last.distance(actual) > 1.0E-6 && Line2D.linesIntersect(x1 = ((Point2D)last).getX(), y1 = ((Point2D)last).getY(), x2 = ((Point2D)actual).getX(), y2 = ((Point2D)actual).getY(), x3 = line.getX1(), y3 = line.getY1(), x4 = line.getX2(), y4 = line.getY2())) {
                double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
                double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
                double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
                return new Point2D.Double(xi, yi);
            }
            pi.next();
        }
        return null;
    }

    public double distBetweenPointAndLineSegment(Line2D line, Point2D point) {
        return this.distBetweenPointAndLineSegment(line.getP1(), line.getP2(), point);
    }

    public double distBetweenPointAndLineSegment(Point2D v, Point2D w, Point2D point) {
        double l2 = v.distanceSq(w);
        if (l2 == 0.0) {
            return point.distance(v);
        }
        double t = ((point.getX() - v.getX()) * (w.getX() - v.getX()) + (point.getY() - v.getY()) * (w.getY() - v.getY())) / l2;
        if (t < 0.0) {
            return point.distance(v);
        }
        if (t > 1.0) {
            return point.distance(w);
        }
        return point.distance(v.getX() + t * (w.getX() - v.getX()), v.getY() + t * (w.getY() - v.getY()));
    }

    public Point2D closestPointOnSegmentLineToPoint(Line2D line, Point2D point) {
        Point2D result = this.closestPointOnSegmentLineToPoint(line.getP1(), line.getP2(), point);
        return result;
    }

    public Point2D closestPointOnSegmentLineToPoint(Point2D v, Point2D w, Point2D p) {
        double l2 = v.distanceSq(w);
        if (l2 == 0.0) {
            return v;
        }
        double t = ((p.getX() - v.getX()) * (w.getX() - v.getX()) + (p.getY() - v.getY()) * (w.getY() - v.getY())) / l2;
        if (t < 0.0) {
            return v;
        }
        if (t > 1.0) {
            return w;
        }
        return new Point2D.Double(v.getX() + t * (w.getX() - v.getX()), v.getY() + t * (w.getY() - v.getY()));
    }
}

