/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.common.geometry;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class EllipseTransformation {
    private static final double PI = Math.PI;
    private static final double PI_1_2 = 1.5707963267948966;
    private static final double PI_3_2 = 4.71238898038469;
    private static Logger logger = Logger.getLogger(EllipseTransformation.class.getName());

    public Point2D getPointOnEllipseByDegree(Ellipse2D ellipse, double angle) {
        return this.getPointOnEllipseByRadian(ellipse, Math.toRadians(angle));
    }

    public Point2D getPointOnEllipseByDegree(double x, double y, double width, double height, double angle) {
        return this.getPointOnEllipseByRadian(x, y, width, height, Math.toRadians(angle));
    }

    public Point2D getPointOnEllipseByRadian(double x, double y, double width, double height, double angle) {
        double boundedAngle;
        for (boundedAngle = angle; boundedAngle < 0.0; boundedAngle += Math.PI * 2) {
        }
        while (boundedAngle > 6.283184307179586) {
            boundedAngle -= Math.PI * 2;
        }
        Point2D.Double result = new Point2D.Double();
        double a = width / 2.0;
        double b = height / 2.0;
        double resX = 0.0;
        double resY = 0.0;
        if (Math.abs(boundedAngle - 0.0) < 1.0E-6) {
            resX = -a;
            resY = 0.0;
        } else if (Math.abs(boundedAngle - Math.PI) < 1.0E-6) {
            resX = a;
            resY = 0.0;
        } else if (Math.abs(boundedAngle - 1.5707963267948966) < 1.0E-6) {
            resX = 0.0;
            resY = -b;
        } else if (Math.abs(boundedAngle - 4.71238898038469) < 1.0E-6) {
            resX = 0.0;
            resY = b;
        } else {
            double tan = Math.tan(boundedAngle);
            resX = a * b / Math.sqrt(b * b + a * a * tan * tan);
            resY = resX * tan;
            if (boundedAngle <= 1.5707963267948966 || boundedAngle > 4.71238898038469) {
                resX = -resX;
                resY = -resY;
            }
        }
        ((Point2D)result).setLocation(resX += x + a, resY += y + b);
        return result;
    }

    public Point2D getPointOnEllipseByRadian(Ellipse2D ellipse, double angle) {
        double width = ellipse.getWidth();
        double height = ellipse.getHeight();
        return this.getPointOnEllipseByRadian(ellipse.getX(), ellipse.getY(), width, height, angle);
    }
}

