/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.common;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final int HEX_BASE = 16;
    private Logger logger = Logger.getLogger(XmlParser.class.getName());
    private DocumentBuilder db;

    protected XmlParser() {
        try {
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InvalidStateException("Problem with xml parser");
        }
    }

    protected Node getNode(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            return node;
        }
        return null;
    }

    protected List<Node> getNodes(String tagName, NodeList nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            result.add(node);
        }
        return result;
    }

    protected String getNodeAttr(String attrName, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        for (int y = 0; y < attrs.getLength(); ++y) {
            Node attr = attrs.item(y);
            if (!attr.getNodeName().equalsIgnoreCase(attrName)) continue;
            return attr.getNodeValue();
        }
        return "";
    }

    protected String getNodeValue(Node node) {
        if (node == null) {
            return "";
        }
        NodeList childNodes = node.getChildNodes();
        for (int x = 0; x < childNodes.getLength(); ++x) {
            Node data = childNodes.item(x);
            if (data.getNodeType() != 3) continue;
            return data.getNodeValue();
        }
        return "";
    }

    protected Document getXmlDocumentFromInputSource(InputSource stream) throws InvalidXmlSchemaException {
        Document doc = null;
        try {
            doc = this.db.parse(stream);
        }
        catch (SAXException e) {
            throw new InvalidXmlSchemaException("Problem with xml parser", e);
        }
        catch (IOException e) {
            throw new InvalidXmlSchemaException("Problem with xml parser", e);
        }
        return doc;
    }

    protected Document getXmlDocumentFromString(String text) throws InvalidXmlSchemaException {
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(text));
        return this.getXmlDocumentFromInputSource(is);
    }

    protected String nodeToString(Node node) {
        return this.nodeToString(node, false);
    }

    protected String nodeToString(Node node, boolean includeHeadNode) {
        if (node == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("method", "xml");
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node element = list.item(i);
                t.transform(new DOMSource(element), new StreamResult(sw));
            }
        }
        catch (TransformerException te) {
            this.logger.debug("nodeToString Transformer Exception");
        }
        if (includeHeadNode) {
            return "<" + node.getNodeName() + ">" + sw.toString() + "</" + node.getNodeName() + ">";
        }
        return sw.toString();
    }

    protected Color stringToColor(String color) {
        try {
            return new Color(this.hexToInteger(color.substring(2)));
        }
        catch (Exception e) {
            throw new InvalidArgumentException("Invalid color string: " + color);
        }
    }

    private Integer hexToInteger(String hexString) {
        return Integer.valueOf(hexString, 16);
    }

    protected String colorToString(Color color) {
        return String.format("%08X", color.getRGB());
    }

    protected String fileToString(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    protected String inputStreamToString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy(inputStream, (Writer)writer, "UTF-8");
        String result = writer.toString();
        return result;
    }

    protected String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml(string).replaceAll("\n", "&#10;").replace("\r", "&#13;");
    }
}

