/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.cdplugin.info;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import org.apache.log4j.Logger;

public final class InfoFrame {
    private static final int DISTANCE_BETWEEN_PANELS = 5;
    private static final int GRID_INFO_COL_NUMBER = 2;
    private static final int GRID_INFO_ROW_NUMBER = 3;
    private static final int FRAME_HEIGHT = 200;
    private static final int FRAME_WIDTH = 200;
    private static final int CAPTION_FONT_SIZE = 18;
    private final Logger logger = Logger.getLogger(InfoFrame.class.getName());
    private JFrame frame = null;
    private static InfoFrame instance = null;
    private Font captionFont = new Font("Default", 0, 18);
    private ArrayList<PluginSpeciesAlias> species = new ArrayList();

    private InfoFrame() {
        int width = 200;
        int height = 200;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        width = Math.min(width, screenWidth);
        height = Math.min(height, screenHeight);
        int posX = (screenWidth - width) / 2;
        int posY = (screenHeight - height) / 2;
        this.frame = new JFrame("Element information");
        this.frame.setSize(width, height);
        this.frame.setLocation(posX, posY);
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(false);
    }

    public static InfoFrame getInstance() {
        if (instance == null) {
            instance = new InfoFrame();
        }
        return instance;
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public void setSpecies(ArrayList<PluginSpeciesAlias> species) {
        this.species = species;
        this.updateSpecies();
    }

    protected void updateSpecies() {
        int panels = this.species.size() + 1;
        JPanel controlArea = new JPanel(new GridLayout(panels, 1));
        controlArea.setLayout(new BoxLayout(controlArea, 1));
        for (PluginSpeciesAlias sp : this.species) {
            JPanel panel = this.getPanelViewForSpecies(sp);
            controlArea.add(panel);
        }
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setBackground(this.frame.getBackground());
        controlArea.add(text);
        Container content = this.frame.getContentPane();
        content.removeAll();
        JScrollPane scrollBar = new JScrollPane(controlArea, 22, 30);
        scrollBar.setPreferredSize(new Dimension(0, 0));
        content.add(scrollBar);
        this.frame.validate();
    }

    private JPanel getPanelViewForSpecies(PluginSpeciesAlias species) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        JPanel tmpPanel = new JPanel(new GridLayout(3, 2));
        JLabel label = new JLabel("Element: ", 4);
        label.setFont(this.captionFont);
        tmpPanel.add((Component)label, Float.valueOf(1.0f));
        JTextField textField = new JTextField(species.getSpecies().getName(), 2);
        textField.setFont(this.captionFont);
        textField.setEditable(false);
        tmpPanel.add((Component)textField, Float.valueOf(0.0f));
        tmpPanel.add((Component)new JLabel("Alias id: ", 4), Float.valueOf(1.0f));
        textField = new JTextField(species.getAliasID(), 2);
        textField.setEditable(false);
        tmpPanel.add((Component)textField, Float.valueOf(0.0f));
        tmpPanel.add((Component)new JLabel("Species id: ", 4), Float.valueOf(1.0f));
        textField = new JTextField(species.getSpecies().getId(), 2);
        textField.setEditable(false);
        tmpPanel.add((Component)textField, Float.valueOf(0.0f));
        result.add(tmpPanel);
        result.add(Box.createRigidArea(new Dimension(5, 5)));
        return result;
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setDefaultCloseOperation(int type) {
        this.frame.setDefaultCloseOperation(type);
    }

    public void setAlwaysOnTop(boolean always) {
        this.frame.setAlwaysOnTop(always);
    }
}

