/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.cdplugin.copypaste;

import java.util.Set;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import lcsb.mapviewer.cdplugin.copypaste.CopyPasteAbstractAction;
import lcsb.mapviewer.cdplugin.copypaste.CopyPastePlugin;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.SystemClipboard;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.model.map.MiriamData;
import org.apache.log4j.Logger;

public class PasteAction
extends CopyPasteAbstractAction {
    private final Logger logger = Logger.getLogger(PasteAction.class.getName());

    public void performAnnotation(CopyPastePlugin plug, PluginListOf speciesList, MainWindow win) {
        XmlAnnotationParser xap = new XmlAnnotationParser();
        if (speciesList.size() == 0) {
            return;
        }
        SystemClipboard sc = new SystemClipboard();
        String value = sc.getClipboardContents();
        Pair<Set<MiriamData>, String> data = this.getAnnotationDataFromClipboardString(value);
        String notes = data.getRight();
        Set<MiriamData> set = data.getLeft();
        this.setWindow(win);
        this.setPlug(plug);
        int size = speciesList.size();
        for (int i = 0; i < size; ++i) {
            PluginSBase element = speciesList.get(i);
            if (element instanceof PluginSpeciesAlias) {
                PluginSpeciesAlias alias = (PluginSpeciesAlias)element;
                PluginSpecies species = alias.getSpecies();
                species.setNotes(notes);
                species.setAnnotationString(xap.dataSetToXmlString(set));
                plug.notifySBaseChanged(element);
                plug.notifySBaseChanged((PluginSBase)species);
                continue;
            }
            if (element instanceof PluginReaction) {
                PluginReaction reaction = (PluginReaction)element;
                reaction.setNotes(notes);
                reaction.setAnnotationString(xap.dataSetToXmlString(set));
                plug.notifySBaseChanged(element);
                continue;
            }
            this.logger.warn("Unknown class type :" + element.getClass());
        }
    }
}

